package com.xebialabs.deployit.plugin.wls.deployed;

import com.xebialabs.deployit.plugin.api.deployment.planning.Create;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.planning.Destroy;
import com.xebialabs.deployit.plugin.api.deployment.planning.Modify;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.Operation;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.python.PythonManagedDeployed;
import com.xebialabs.deployit.plugin.wls.container.WlsContainer;

import static com.google.common.base.Strings.isNullOrEmpty;

@SuppressWarnings("serial")
@Metadata(virtual = true, description = "Base deployed of all Resources")
public class Resource<D extends Deployable> extends PythonManagedDeployed<D, WlsContainer> {

    @SuppressWarnings("unused")
    @Property(hidden = true, defaultValue = "id, name, type, _properties, deployable, container, createScript, createVerb, createOrder, modifyScript, modifyVerb, modifyOrder, securityPermissions, " +
            "inheritPermissions, exposeDeployedApplication, destroyScript, destroyVerb, destroyOrder, jndiName, restartTarget, libraryScripts, discoverOrder")
    private String standardPropertiesNotToExpose;

    @Property(hidden = true, required = false, description = "Python script invoked to create this resource")
    private String createScript;

    @Property(hidden = true, defaultValue = "Create")
    private String createVerb;

    @Property(hidden = true, defaultValue = "60")
    private int createOrder;

    @Property(hidden = true, required = false, description = "Python script invoked to upgrade this resource")
    private String modifyScript;

    @Property(hidden = true, defaultValue = "Upgrade")
    private String modifyVerb;

    @Property(hidden = true, defaultValue = "40")
    private int modifyOrder;

    @Property(hidden = true, required = false, description = "Python script invoked to destroy this resource")
    private String destroyScript;

    @Property(hidden = true, defaultValue = "Destroy")
    private String destroyVerb;

    @Property(hidden = true, defaultValue = "40")
    private int destroyOrder;

    @Property(required = false, defaultValue = "false", description = "If set to true, a restart operation (stop & start) will be triggered just after the creation or the deletion of the resource")
    boolean restartTarget;

    @Create
    public void createResource(DeploymentPlanningContext result, Delta delta) {
        addStep(result, createOrder, createScript, createVerb, checkpoint(delta, Operation.CREATE));
    }

    @Modify
    public void modifyResource(DeploymentPlanningContext result, Delta delta) {
        if (!isNullOrEmpty(modifyScript)) {
            addStep(result, modifyOrder, modifyScript, modifyVerb, checkpoint(delta));
        } else {
            destroyResource(result, delta);
            createResource(result, delta);
        }
    }

    @Destroy
    public void destroyResource(DeploymentPlanningContext result, Delta delta) {
        addStep(result, destroyOrder, destroyScript, destroyVerb, checkpoint(delta, Operation.DESTROY));
    }
}
