package com.xebialabs.deployit.plugin.wls.container;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;

import com.xebialabs.deployit.plugin.api.inspection.InspectionContext;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.python.PythonInspectionStep;
import com.xebialabs.deployit.plugin.python.PythonManagedContainer;
import com.xebialabs.deployit.plugin.python.PythonManagedDeployed;

import static com.google.common.collect.Maps.newHashMap;


public class DelegatedInspectionHelper {

    public static final String DISCOVER_SCRIPT_PROPERTY_NAME = "discoverScript";

    public static void discoverDeployeds(PythonManagedContainer container, InspectionContext ctx) {
        discoverDeployeds(container, ctx, DescriptorRegistry.getSubtypes(Type.valueOf(PythonManagedDeployed.class)));
    }

    public static void discoverDeployeds(PythonManagedContainer container, InspectionContext ctx, Iterable<Type> types) {
        Multimap<Integer, PythonInspectionStep> steps = newSortedKeyMultimapForSteps();
        final Type containerT = container.getType();
        for (Type deployedT : types) {
            final Descriptor deployedD = deployedT.getDescriptor();
            logger.debug("Checking whether type [{}] is not virtual", deployedT);
            if (deployedD.isVirtual()) {
                continue;
            }

            final Type deployedContainerT = deployedD.getContainerType();
            final Type wasContainerT = Type.valueOf(WlsContainer.class);
            logger.debug("Checking whether type [{}] is instance of type [{}]", deployedContainerT, wasContainerT);
            if (!containerT.instanceOf(wasContainerT)) {
                continue;
            }

            logger.debug("Checking whether type [{}] has a discoveryScript property", deployedT);
            final PropertyDescriptor discoveryScriptProperty = deployedD.getPropertyDescriptor(DISCOVER_SCRIPT_PROPERTY_NAME);
            if (discoveryScriptProperty == null) {
                continue;
            }

            logger.debug("Checking whether the " + DISCOVER_SCRIPT_PROPERTY_NAME + " property of type [{}] has a default value", deployedT);
            final Object defaultValue = discoveryScriptProperty.getDefaultValue();
            if (defaultValue == null) {
                continue;
            }

            logger.debug("Checking whether the " + DISCOVER_SCRIPT_PROPERTY_NAME + " property of type [{}] has a string value", deployedD.getType());
            if (!(defaultValue instanceof String)) {
                continue;
            }

            final String scriptName = (String) defaultValue;
            logger.debug("Adding inspection step using script {} for container {}", scriptName, container);
            final Map<String, Object> pythonVars = newHashMap();
            pythonVars.put("container", container);
            PythonManagedDeployed<?, ?> prototype = deployedD.newInstance();
            pythonVars.put("prototype", prototype);
            PythonInspectionStep step = new PythonInspectionStep(container, container.getManagingContainer(), scriptName, pythonVars, "Discover objects of type " + deployedT
                    + " on " + container);
            steps.put(prototype.getDiscoverOrder(), step);
        }

        for (PythonInspectionStep step : steps.values()) {
            ctx.addStep(step);
        }
    }

    private static Multimap<Integer, PythonInspectionStep> newSortedKeyMultimapForSteps() {
        return Multimaps.newListMultimap(new TreeMap<Integer, Collection<PythonInspectionStep>>(), new Supplier<List<PythonInspectionStep>>() {
            public List<PythonInspectionStep> get() {
                return Lists.newArrayList();
            }
        });
    }

    private static Logger logger = LoggerFactory.getLogger(DelegatedInspectionHelper.class);

}
