/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wls.validator;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.plugin.api.deployment.planning.PrePlanProcessor;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.DeltaSpecification;
import com.xebialabs.deployit.plugin.api.deployment.specification.Operation;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.plugin.api.udm.DeployableArtifact;
import com.xebialabs.deployit.plugin.wls.container.Cluster;
import com.xebialabs.deployit.plugin.wls.container.Domain;
import com.xebialabs.deployit.plugin.wls.container.JmsServer;
import com.xebialabs.deployit.plugin.wls.container.JmsTarget;
import com.xebialabs.deployit.plugin.wls.container.WlsContainer;
import com.xebialabs.deployit.plugin.wls.deployed.AbstractQueue;
import com.xebialabs.deployit.plugin.wls.deployed.AbstractUniformDistributedQueue;
import com.xebialabs.deployit.plugin.wls.deployed.ExtensibleDeployedArtifact;
import com.xebialabs.deployit.plugin.wls.deployed.JmsResource;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class PlanLevelValidator {
    public static final Predicate<Delta> CREATE_OR_MODIFY_QUEUE_FILTER = new Predicate<Delta>(){

        public boolean apply(Delta input) {
            return EnumSet.of(Operation.CREATE, Operation.MODIFY).contains(input.getOperation()) && AbstractQueue.class.isAssignableFrom(input.getDeployed().getClass());
        }
    };

    @PrePlanProcessor
    public Step validatePlan(DeltaSpecification spec) {
        PlanLevelValidator.validateArtifactDeploymentOptions(spec);
        PlanLevelValidator.validateUniqueJNDIName(spec);
        PlanLevelValidator.validateUniformDistributedQueues(spec);
        PlanLevelValidator.validateQueueIsTargetedToSingleJmsServerWithinDomain(spec);
        return null;
    }

    private static void validateArtifactDeploymentOptions(DeltaSpecification spec) {
        Multimap<Deployable, ExtensibleDeployedArtifact<DeployableArtifact>> deployeds = PlanLevelValidator.getAllDeployedArtifacts(spec);
        for (Deployable eachArtifact : deployeds.keySet()) {
            Collection artifactDeployeds = deployeds.get((Object)eachArtifact);
            PlanLevelValidator.validateDeploymentOptionsAreSame(artifactDeployeds);
        }
    }

    private static Multimap<Deployable, ExtensibleDeployedArtifact<DeployableArtifact>> getAllDeployedArtifacts(DeltaSpecification spec) {
        HashMultimap deployeds = HashMultimap.create();
        for (Delta each : spec.getDeltas()) {
            if (each.getOperation() != Operation.CREATE && each.getOperation() != Operation.MODIFY || !ExtensibleDeployedArtifact.class.isAssignableFrom(each.getDeployed().getClass())) continue;
            ExtensibleDeployedArtifact artifact = (ExtensibleDeployedArtifact)each.getDeployed();
            deployeds.put((Object)artifact.getDeployable(), (Object)artifact);
        }
        return deployeds;
    }

    private static void validateDeploymentOptionsAreSame(Collection<ExtensibleDeployedArtifact<DeployableArtifact>> artifactDeployeds) {
        Iterator<ExtensibleDeployedArtifact<DeployableArtifact>> iterator = artifactDeployeds.iterator();
        if (iterator.hasNext()) {
            ExtensibleDeployedArtifact<DeployableArtifact> reference = iterator.next();
            while (iterator.hasNext()) {
                ExtensibleDeployedArtifact<DeployableArtifact> next = iterator.next();
                PlanLevelValidator.validateSameValues(reference, next);
            }
        }
    }

    private static void validateSameValues(ExtensibleDeployedArtifact<DeployableArtifact> reference, ExtensibleDeployedArtifact<DeployableArtifact> deployed) {
        if (((WlsContainer)reference.getContainer()).getDomain().equals(((WlsContainer)deployed.getContainer()).getDomain())) {
            if (reference.isVersioned() != deployed.isVersioned()) {
                throw new RuntimeException("Can't have different values for 'versioned' property for same artifact " + ((DeployableArtifact)reference.getDeployable()).getName());
            }
            if (reference.getStageMode() != deployed.getStageMode()) {
                throw new RuntimeException("Can't have different values for 'stageMode' property for same artifact " + ((DeployableArtifact)reference.getDeployable()).getName());
            }
            if (reference.getStagingDirectory() != null && !reference.getStagingDirectory().equals(deployed.getStagingDirectory())) {
                throw new RuntimeException("Can't have different values for 'stagingDirectory' property for same artifact " + ((DeployableArtifact)reference.getDeployable()).getName());
            }
            if (reference.getRedeploymentStrategy() != deployed.getRedeploymentStrategy()) {
                throw new RuntimeException("Can't have different values for the deployment strategy for the same artifact " + ((DeployableArtifact)reference.getDeployable()).getName());
            }
        }
    }

    private static void validateUniqueJNDIName(DeltaSpecification spec) {
        HashMap<String, String> jndiNames = new HashMap<String, String>();
        for (Delta each : spec.getDeltas()) {
            if (each.getOperation() != Operation.CREATE && each.getOperation() != Operation.MODIFY || !JmsResource.class.isAssignableFrom(each.getDeployed().getClass())) continue;
            JmsResource jmsResource = (JmsResource)each.getDeployed();
            String jndiName = jmsResource.getJndiName();
            String name = jmsResource.getName();
            if (jndiNames.get(jndiName) != null && !((String)jndiNames.get(jndiName)).equals(name)) {
                throw new RuntimeException(String.format("Jndi name %s is in use by multiple resource sources", jndiName));
            }
            jndiNames.put(jndiName, name);
        }
    }

    private static void validateUniformDistributedQueues(DeltaSpecification spec) {
        HashMap<String, Cluster> uddQueueContainers = new HashMap<String, Cluster>();
        for (Delta each : spec.getDeltas()) {
            if (each.getOperation() != Operation.CREATE && each.getOperation() != Operation.MODIFY || !AbstractUniformDistributedQueue.class.isAssignableFrom(each.getDeployed().getClass())) continue;
            AbstractUniformDistributedQueue jmsResource = (AbstractUniformDistributedQueue)each.getDeployed();
            Cluster cluster = PlanLevelValidator.getContainerCluster(jmsResource);
            String jmsResourceName = jmsResource.getName();
            if (uddQueueContainers.containsKey(jmsResourceName) && !((Cluster)uddQueueContainers.get(jmsResourceName)).equals(cluster)) {
                throw new RuntimeException(String.format("The UDD %s must be targeted to servers within a single cluster or a single stand-alone server", jmsResourceName));
            }
            uddQueueContainers.put(jmsResourceName, cluster);
        }
    }

    private static void validateQueueIsTargetedToSingleJmsServerWithinDomain(DeltaSpecification spec) {
        FluentIterable queues = FluentIterable.from((Iterable)spec.getDeltas()).filter(CREATE_OR_MODIFY_QUEUE_FILTER).transform((Function)new Function<Delta, AbstractQueue>(){

            public AbstractQueue apply(Delta input) {
                return (AbstractQueue)input.getDeployed();
            }
        });
        ImmutableListMultimap queueByName = Multimaps.index((Iterable)queues, (Function)new Function<AbstractQueue, String>(){

            public String apply(AbstractQueue input) {
                return input.getName();
            }
        });
        for (String queueName : queueByName.keySet()) {
            if (!PlanLevelValidator.checkDuplicates(Lists.transform((List)queueByName.get((Object)queueName), (Function)new Function<AbstractQueue, Domain>(){

                public Domain apply(AbstractQueue input) {
                    return ((JmsServer)input.getContainer()).getDomain();
                }
            }))) continue;
            throw new RuntimeException(String.format("Queue %s must be targeted to only a single JmsServer in the same Domain.", queueName));
        }
    }

    private static <T> boolean checkDuplicates(List<T> list) {
        return Sets.newHashSet(list).size() < list.size();
    }

    private static Cluster getContainerCluster(AbstractUniformDistributedQueue jmsResource) {
        JmsTarget container = (JmsTarget)jmsResource.getContainer();
        Cluster cluster = null;
        if (Cluster.class.isAssignableFrom(container.getClass())) {
            cluster = (Cluster)container;
        } else if (JmsServer.class.isAssignableFrom(container.getClass())) {
            cluster = ((JmsServer)container).getServer().getClusterIfAny();
        }
        return cluster;
    }
}

