package com.xebialabs.deployit.plugin.wls.step;

import com.google.common.collect.ImmutableMap;
import com.xebialabs.deployit.plugin.python.PythonDeploymentStep;
import com.xebialabs.deployit.plugin.wls.container.Server;
import com.xebialabs.deployit.plugin.wls.container.WlsContainer;

@SuppressWarnings("serial")
public class StopWlsTargetStep extends PythonDeploymentStep {

    public StopWlsTargetStep(int order, WlsContainer target) {
        super(order, target.getManagingContainer(), "wls/container/stop-target.py", buildPythonVars(target), "Stop " + target);
    }

    private static ImmutableMap<String, Object> buildPythonVars(WlsContainer target) {
        return new ImmutableMap.Builder<String, Object>().put("target", target).put("type", (target instanceof Server ? "Server" : "Cluster")).build();
    }
}
