/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wls.contributor;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.plugin.api.deployment.planning.Contributor;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.Deltas;
import com.xebialabs.deployit.plugin.api.deployment.specification.Operation;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.wls.ResourceTargetRestartPolicy;
import com.xebialabs.deployit.plugin.wls.container.JmsServer;
import com.xebialabs.deployit.plugin.wls.container.WlsContainer;
import com.xebialabs.deployit.plugin.wls.contributor.Predicates2;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WlsContainerRestartWithCalculatedOrdersContributor {
    static final int SHIFT_RESTART_ORDERS = 1;
    protected static final Logger logger = LoggerFactory.getLogger(WlsContainerRestartWithCalculatedOrdersContributor.class);

    @Contributor
    public void restartAfterDeployResourcesOrCopiedArtifact(Deltas deltas, DeploymentPlanningContext result) {
        Set restartableDeployed = Sets.filter(WlsContainerRestartWithCalculatedOrdersContributor.gatherTargets(deltas.getDeltas()), (Predicate)new Predicate<Deployed<?, ?>>(){

            public boolean apply(Deployed<?, ?> deployed) {
                boolean restartTarget = (Boolean)deployed.getProperty("restartTarget");
                if (deployed.hasProperty("targetRestartPolicy")) {
                    ResourceTargetRestartPolicy rds = (ResourceTargetRestartPolicy)((Object)deployed.getProperty("targetRestartPolicy"));
                    return restartTarget && rds == ResourceTargetRestartPolicy.RESTART;
                }
                return restartTarget;
            }
        });
        logger.debug("restartable deployeds {}", (Object)restartableDeployed);
        HashMap ordersByContainer = Maps.newHashMap();
        for (Deployed target : restartableDeployed) {
            WlsContainer container;
            int createOrder = (Integer)target.getProperty("createOrder");
            if (target.getContainer() instanceof JmsServer) {
                JmsServer server = (JmsServer)target.getContainer();
                container = server.getServer();
            } else {
                container = (WlsContainer)target.getContainer();
            }
            if (!ordersByContainer.containsKey(container)) {
                ordersByContainer.put(container, 0);
            }
            if (createOrder <= (Integer)ordersByContainer.get(container)) continue;
            ordersByContainer.put(container, createOrder);
        }
        Collection steps = Maps.transformEntries((Map)ordersByContainer, (Maps.EntryTransformer)new Maps.EntryTransformer<WlsContainer, Integer, List<Step>>(){

            public List<Step> transformEntry(WlsContainer container, Integer order) {
                logger.debug("create stop/start step for {} --> {} ", (Object)container, (Object)order);
                ImmutableList.Builder builder = new ImmutableList.Builder();
                int restartOrder = order + 1;
                builder.addAll(container.getStopSteps(restartOrder));
                builder.addAll(container.getStartSteps(restartOrder));
                return builder.build();
            }
        }).values();
        result.addSteps(Iterables.concat(steps));
    }

    private static Set<Deployed<?, ?>> gatherTargets(List<Delta> operations) {
        logger.trace("WlsContainerRestartWithCalculatedOrdersContributor.gatherTargets");
        Type resourcesType = DescriptorRegistry.getDescriptor((String)"wls.Resource").getType();
        Type copiedArtifactType = DescriptorRegistry.getDescriptor((String)"wls.CopiedArtifact").getType();
        Iterable filter = Iterables.filter(operations, (Predicate)Predicates.and((Predicate)Predicates.not(Predicates2.operationIs(Operation.NOOP)), (Predicate)Predicates.or(Predicates2.deltaOf(resourcesType), Predicates2.deltaOf(copiedArtifactType))));
        Iterable transform = Iterables.transform((Iterable)filter, Predicates2.extractDeployed());
        HashSet deployeds = Sets.newHashSet((Iterable)transform);
        logger.debug("deployed {}", (Object)deployeds);
        return deployeds;
    }
}

