package com.xebialabs.deployit.plugin.wls.deployed;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import com.google.common.base.Predicate;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;

import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.planning.Modify;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.api.inspection.InspectionContext;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.services.Repository;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.validation.Placeholders;
import com.xebialabs.deployit.plugin.python.PythonDeploymentStep;
import com.xebialabs.deployit.plugin.wls.container.WlsContainer;
import com.xebialabs.deployit.plugin.wls.utils.ModifiedDelta;

import static com.google.common.collect.Iterables.filter;
import static com.google.common.collect.Maps.newHashMap;

@SuppressWarnings("serial")
@Metadata(virtual = true, description = "Base class for all shared library deployeds")
@Placeholders
public class ExtensibleDeployedSharedLibrary extends ExtensibleDeployedArtifact {

    private static final Logger logger = LoggerFactory.getLogger(ExtensibleDeployedSharedLibrary.class);

    @Property(defaultValue = "wls.EarModule, wls.WarModule", hidden = true)
    private List<String> runtimeDependenciesTypes;

    @SuppressWarnings({"unchecked"})
    @Modify
    public void handleRuntimeDependencies(DeploymentPlanningContext context, Delta delta) {
        try {
            final List<ConfigurationItem> deployedArtifacts = searchRuntimeDeployeds(context);
            logger.debug("deployedArtifacts: " + deployedArtifacts);

            final ConfigurationItem deployed = this;
            final Iterable<ConfigurationItem> runtimeDependenciesDeployedArtifacts = filter(deployedArtifacts, new Predicate<ConfigurationItem>() {
                @Override
                public boolean apply(final ConfigurationItem input) {
                    final List<ConfigurationItem> sharedLibraries = input.getProperty("sharedLibraries");
                    return sharedLibraries.contains(deployed);
                }
            });

            for (ConfigurationItem configurationItem : runtimeDependenciesDeployedArtifacts) {
                logger.debug("%s(%s) Operation.MODIFY", configurationItem.getId(), configurationItem.getType());
                ExtensibleDeployedArtifact artifact = (ExtensibleDeployedArtifact) context.getRepository().read(configurationItem.getId());
                Delta deltaArtifact = new ModifiedDelta(artifact);
                artifact.stopApplicationForModifedArtifact(context, deltaArtifact);
                artifact.modifyArtifact(context, deltaArtifact);
                artifact.startApplication(context);
            }
        } catch (Exception e) {
            Throwables.propagate(e);
        }
    }

    private List<ConfigurationItem> searchRuntimeDeployeds(final DeploymentPlanningContext context) {
        final ImmutableList.Builder builder = new ImmutableList.Builder();
        final Repository repository = context.getRepository();
        for (String type : runtimeDependenciesTypes) {
            builder.addAll(repository.search(Type.valueOf(type), getContainer().getId()));
        }
        return builder.build();
    }

}
