/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wls.deployed;

import com.google.common.base.Strings;
import com.xebialabs.deployit.plugin.api.deployment.planning.Create;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.planning.Destroy;
import com.xebialabs.deployit.plugin.api.deployment.planning.Modify;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.Operation;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.python.PythonManagedDeployed;
import com.xebialabs.deployit.plugin.wls.ResourceTargetRestartPolicy;
import com.xebialabs.deployit.plugin.wls.container.WlsContainer;

@Metadata(virtual=true, description="Base deployed of all Resources")
public class Resource<D extends Deployable>
extends PythonManagedDeployed<D, WlsContainer> {
    @Property(hidden=true, defaultValue="id, name, type, _properties, deployable, container, createScript, createVerb, createOrder, modifyScript, modifyVerb, modifyOrder, securityPermissions, inheritPermissions, exposeDeployedApplication, destroyScript, destroyVerb, destroyOrder, jndiName, restartTarget, libraryScripts, discoverOrder,targetRestartPolicy")
    private String standardPropertiesNotToExpose;
    @Property(required=true, defaultValue="RESTART", description="Indicates the policy used to stop/start the target container when resource restartTarget property is 'true'")
    private ResourceTargetRestartPolicy targetRestartPolicy;
    @Property(hidden=true, required=false, description="Python script invoked to create this resource")
    private String createScript;
    @Property(hidden=true, defaultValue="Create")
    private String createVerb;
    @Property(hidden=true, defaultValue="60")
    private int createOrder;
    @Property(hidden=true, required=false, description="Python script invoked to upgrade this resource")
    private String modifyScript;
    @Property(hidden=true, defaultValue="Upgrade")
    private String modifyVerb;
    @Property(hidden=true, defaultValue="40")
    private int modifyOrder;
    @Property(hidden=true, required=false, description="Python script invoked to destroy this resource")
    private String destroyScript;
    @Property(hidden=true, defaultValue="Destroy")
    private String destroyVerb;
    @Property(hidden=true, defaultValue="40")
    private int destroyOrder;
    @Property(required=false, defaultValue="false", description="If set to true, a restart operation (stop & start) will be triggered just after the creation or the deletion of the resource")
    boolean restartTarget;

    @Create
    public void createResource(DeploymentPlanningContext result, Delta delta) {
        this.addStep(result, this.createOrder, this.createScript, this.createVerb, Resource.checkpoint((Delta)delta, (Operation)Operation.CREATE));
    }

    @Modify
    public void modifyResource(DeploymentPlanningContext result, Delta delta) {
        if (!Strings.isNullOrEmpty((String)this.modifyScript)) {
            this.addStep(result, this.modifyOrder, this.modifyScript, this.modifyVerb, Resource.checkpoint((Delta)delta));
        } else {
            this.destroyResource(result, delta);
            this.createResource(result, delta);
        }
    }

    @Destroy
    public void destroyResource(DeploymentPlanningContext result, Delta delta) {
        this.addStep(result, this.destroyOrder, this.destroyScript, this.destroyVerb, Resource.checkpoint((Delta)delta, (Operation)Operation.DESTROY));
    }

    public ResourceTargetRestartPolicy getTargetRestartPolicy() {
        return this.targetRestartPolicy;
    }

    public void setTargetRestartPolicy(ResourceTargetRestartPolicy targetRestartPolicy) {
        this.targetRestartPolicy = targetRestartPolicy;
    }

    public boolean isRestartTarget() {
        return this.restartTarget;
    }

    public void setRestartTarget(boolean restartTarget) {
        this.restartTarget = restartTarget;
    }
}

