/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wls.container;

import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.inspection.Inspect;
import com.xebialabs.deployit.plugin.api.inspection.InspectionContext;
import com.xebialabs.deployit.plugin.api.inspection.InspectionProperty;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseContainer;
import com.xebialabs.deployit.plugin.overthere.Host;
import com.xebialabs.deployit.plugin.python.ControlTaskDelegate;
import com.xebialabs.deployit.plugin.python.PythonInspectionStep;
import com.xebialabs.deployit.plugin.python.PythonManagedContainer;
import com.xebialabs.deployit.plugin.python.PythonManagingContainer;
import com.xebialabs.deployit.plugin.wls.DeploymentMode;
import com.xebialabs.deployit.plugin.wls.container.Cluster;
import com.xebialabs.deployit.plugin.wls.container.DelegatedInspectionHelper;
import com.xebialabs.deployit.plugin.wls.container.Server;
import com.xebialabs.deployit.plugin.wls.container.StartMode;
import com.xebialabs.deployit.plugin.wls.container.Version;
import com.xebialabs.deployit.plugin.wls.container.WlsContainer;
import com.xebialabs.deployit.plugin.wls.container.WlsProtocol;
import com.xebialabs.deployit.plugin.wls.freemarker.TemplateEvaluator;
import com.xebialabs.overthere.CmdLine;
import com.xebialabs.overthere.OperatingSystemFamily;
import com.xebialabs.overthere.OverthereFile;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Metadata(root=Metadata.ConfigurationItemRoot.INFRASTRUCTURE, description="WebLogic Domain which is a collection of WebLogic Server instances that is managed by a single Administration Server", inspectable=true)
public class Domain
extends BaseContainer
implements PythonManagingContainer,
PythonManagedContainer,
WlsContainer {
    @Property(required=true, label="Host", description="The host that runs the admin server")
    @InspectionProperty
    private Host host;
    @Property(required=true, defaultValue="WEBLOGIC_10", label="Version", description="Version of Oracle WebLogic Server")
    @InspectionProperty
    private Version version;
    @Property(required=true, label="WebLogic home", description="The location of the WebLogic Server installation")
    @InspectionProperty
    private String wlHome;
    @Property(required=false, label="WebLogic domain home", description="The location of the WebLogic domain. Defaults to <wlHome>/../user_projects/domains/<name> (Unix) or <wlHome>\\..\\user_projects\\domains\\<name> (Windows)")
    private String domainHome;
    @Property(required=false, label="WLST path", description="Location of the wlst binary. Defaults to <wlHome>/common/bin/wlst.sh (Unix) or <wlHome>\\common\\bin\\wlst.cmd (Windows)")
    @InspectionProperty(required=false)
    private String wlstPath;
    @Property(required=false, hidden=true, description="Path containing the custom wlst templates: wlst.sh.ftl (Unix) and wlst.cmd.ftl (Windows)")
    private String customWlstTemplatePath;
    @Property(defaultValue="t3", required=true, label="Administrative server protocol", description="Protocol to be used by the AdminServer for this domain")
    @InspectionProperty(required=false)
    private WlsProtocol protocol;
    @Property(required=false, label="Administrative server host", description="Host to connect to for WLST")
    @InspectionProperty(required=false)
    private String hostname;
    @Property(required=true, defaultValue="7001", label="Administrative server port", description="Port to be used by the AdminServer for this domain")
    @InspectionProperty(required=false)
    private int port;
    @Property(required=true, label="Administrative username", description="Username which is used to login to the WebLogic Domain.")
    @InspectionProperty
    private String username;
    @Property(required=true, label="Administrative password", password=true, description="Password which is used to login to the WebLogic Domain.")
    @InspectionProperty
    private String password;
    @Property(required=true, defaultValue="AdminServer", description="The name of the admin server")
    private String adminServerName;
    @Property(required=true, defaultValue="NodeManager", label="Start Mode", description="Tells how a managed server is start and stop, default is NodeManager, others are Script or Windows Service")
    private StartMode startMode;
    @Property(required=false, defaultValue="true", hidden=true, label="Run with daemon", description="Set to true to execute commands with the Python daemon")
    private boolean runWithDaemon;
    @Property(required=false, defaultValue="SINGLE_TARGET", label="Deployment mode", category="Deployment", description="Specify if deploy, undeploy, start and stop operations should be batched and target multiple servers as part of one WLST command. Valid values: 'SINGLE_TARGET' (default, issues a separate call to each target server), 'MULTI_TARGET' (issues one call for multiple target servers by setting the WLST targets options).")
    private DeploymentMode deploymentMode;
    @Property(description="WebLogic servers belonging to domain", category="Topology", asContainment=true)
    private Set<Server> servers = Sets.newHashSet();
    @Property(description="WebLogic clusters belonging to domain", category="Topology", asContainment=true)
    private Set<Cluster> clusters = Sets.newHashSet();
    @Property(required=true, defaultValue="80", hidden=true)
    private int startOrder;
    @Property(required=true, defaultValue="20", hidden=true)
    private int stopOrder;
    @Property(required=true, defaultValue="100", hidden=true, description="Order used to trigger the clean of the JMS Modules of the domain")
    private int destroyJmsModuleOrder;
    @Property(hidden=true, defaultValue="wls.FilePersistentStore")
    private Set<String> deployedsToDiscover = Sets.newHashSet();

    public PythonManagingContainer getManagingContainer() {
        return this;
    }

    public CmdLine getScriptCommandLine(OverthereFile script) {
        if (Strings.isNullOrEmpty((String)this.customWlstTemplatePath)) {
            return this.getStandardScriptCommandLine(script);
        }
        return this.getCustomScriptCommandLine(script);
    }

    private CmdLine getCustomScriptCommandLine(OverthereFile script) {
        OverthereFile remoteWlst;
        String templatePath;
        CmdLine cmdLine = new CmdLine();
        if (this.getHost().getOs() == OperatingSystemFamily.UNIX) {
            templatePath = this.customWlstTemplatePath + "/wlst.sh.ftl";
            remoteWlst = script.getParentFile().getFile("wlst.sh");
            cmdLine.addArgument("sh");
        } else {
            templatePath = this.customWlstTemplatePath + "/wlst.cmd.ftl";
            remoteWlst = script.getParentFile().getFile("wlst.cmd");
        }
        TemplateEvaluator.evaluateTemplate(remoteWlst, templatePath, (Map<String, Object>)ImmutableMap.of((Object)"container", (Object)this, (Object)"script", (Object)script.getPath()));
        cmdLine.addArgument(remoteWlst.getPath());
        return cmdLine;
    }

    private CmdLine getStandardScriptCommandLine(OverthereFile script) {
        CmdLine newCmdLine = new CmdLine();
        newCmdLine.addArgument(this.getWlstPath());
        newCmdLine.addArgument("-i");
        newCmdLine.addArgument(script.getPath());
        newCmdLine.addArgument(this.getUsername());
        newCmdLine.addPassword(this.getPassword());
        String hostForURL = Strings.isNullOrEmpty((String)this.hostname) ? this.host.getProperty("address").toString() : this.hostname;
        newCmdLine.addArgument((Object)((Object)this.protocol) + "://" + hostForURL + ":" + this.port);
        return newCmdLine;
    }

    @Inspect
    public void inspect(InspectionContext ctx) {
        HashMap pythonVars = Maps.newHashMap();
        pythonVars.put("container", this);
        ctx.addStep((Step)new PythonInspectionStep((ConfigurationItem)this, (PythonManagingContainer)this, "wls/container/inspect-domain.py", (Map)pythonVars, "Inspect " + this));
        Iterable typesToDiscovery = Iterables.transform(this.deployedsToDiscover, (Function)new Function<String, Type>(){

            public Type apply(String input) {
                return Type.valueOf((String)input);
            }
        });
        DelegatedInspectionHelper.discoverDeployeds(this, ctx, Lists.newArrayList((Iterable)typesToDiscovery));
    }

    public List<Step> controlTaskDispatch(String name, Map<String, String> args) {
        return ControlTaskDelegate.dispatch((String)name, args, (ConfigurationItem)this, (Container)this);
    }

    public Host getHost() {
        return this.host;
    }

    public void setHost(Host activeHost) {
        this.host = activeHost;
    }

    public Set<String> getDeployedsToDiscover() {
        return this.deployedsToDiscover;
    }

    public void setDeployedsToDiscover(Set<String> deployedsToDiscover) {
        this.deployedsToDiscover = deployedsToDiscover;
    }

    public Version getVersion() {
        return this.version;
    }

    public void setVersion(Version version) {
        this.version = version;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getWlHome() {
        return this.wlHome;
    }

    public void setWlHome(String wlHome) {
        this.wlHome = wlHome;
    }

    public String getDomainHome() {
        return Strings.isNullOrEmpty((String)this.domainHome) ? this.getDefaultDomainHome() : this.domainHome;
    }

    private String getDefaultDomainHome() {
        String fileSeparator = this.host.getOs().getFileSeparator();
        return this.wlHome.substring(0, this.wlHome.lastIndexOf(fileSeparator)) + fileSeparator + "user_projects" + fileSeparator + "domains" + fileSeparator + this.getName();
    }

    public void setDomainHome(String domainHome) {
        this.domainHome = domainHome;
    }

    public String getWlstPath() {
        return Strings.isNullOrEmpty((String)this.wlstPath) ? this.getDefaultWlstPath() : this.wlstPath;
    }

    private String getDefaultWlstPath() {
        String fileSeparator = this.getHost().getOs().getFileSeparator();
        String wlstExtension = this.getHost().getOs() == OperatingSystemFamily.WINDOWS ? ".cmd" : ".sh";
        return this.wlHome + fileSeparator + "common" + fileSeparator + "bin" + fileSeparator + "wlst" + wlstExtension;
    }

    public void setWlstPath(String wlstPath) {
        this.wlstPath = wlstPath;
    }

    public String getAdminServerName() {
        return this.adminServerName;
    }

    public void setAdminServerName(String adminServerName) {
        this.adminServerName = adminServerName;
    }

    public void setUseNodeManager(boolean useNodeManager) {
        this.startMode = StartMode.NodeManager;
    }

    public StartMode getStartMode() {
        return this.startMode;
    }

    public void setStartMode(StartMode startMode) {
        this.startMode = startMode;
    }

    public Set<Cluster> getClusters() {
        return this.clusters;
    }

    public void addClusters(Cluster cluster) {
        this.clusters.add(cluster);
    }

    public String getRuntimePath() {
        return "wls/runtime";
    }

    public boolean runWithDaemon() {
        return this.runWithDaemon;
    }

    public void setRunWithDaemon(boolean runWithDaemon) {
        this.runWithDaemon = runWithDaemon;
    }

    public DeploymentMode getDeploymentMode() {
        return this.deploymentMode;
    }

    public void setDeploymentMode(DeploymentMode deploymentMode) {
        this.deploymentMode = deploymentMode;
    }

    @Override
    public Domain getDomain() {
        return this;
    }

    @Override
    public String getObjectName() {
        return "com.bea:Name=" + this.getName() + ",Type=Domain";
    }

    @Override
    public Set<Host> getHosts() {
        return Sets.newHashSet((Iterable)Iterables.transform(this.servers, (Function)new Function<Server, Host>(){

            public Host apply(Server host) {
                return host.getHost();
            }
        }));
    }

    @Override
    public Set<Server> getServers() {
        return this.servers;
    }

    @Override
    public int getStopOrder() {
        return this.stopOrder;
    }

    @Override
    public int getStartOrder() {
        return this.startOrder;
    }

    @Override
    public List<Step> getStartSteps(final int order) {
        return Lists.newArrayList((Iterable)Iterables.concat((Iterable)Iterables.transform(this.servers, (Function)new Function<Server, List<Step>>(){

            public List<Step> apply(Server server) {
                return server.getStartSteps(order);
            }
        })));
    }

    @Override
    public List<Step> getStopSteps(final int order) {
        return Lists.newArrayList((Iterable)Iterables.concat((Iterable)Iterables.transform(this.servers, (Function)new Function<Server, List<Step>>(){

            public List<Step> apply(Server server) {
                return server.getStopSteps(order);
            }
        })));
    }

    public int getDestroyJmsModuleOrder() {
        return this.destroyJmsModuleOrder;
    }
}

