/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wls.contributor;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.xebialabs.deployit.plugin.api.deployment.planning.Contributor;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.Deltas;
import com.xebialabs.deployit.plugin.api.deployment.specification.Operation;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.services.Repository;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.wls.contributor.Predicates2;
import com.xebialabs.deployit.plugin.wls.deployed.ExtensibleDeployedArtifact;
import com.xebialabs.deployit.plugin.wls.deployed.ExtensibleDeployedSharedLibrary;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RefreshSharedLibRuntimeDependencies {
    private static final Logger logger = LoggerFactory.getLogger(RefreshSharedLibRuntimeDependencies.class);

    @Contributor
    public static void handleRuntimeDepenencies(final Deltas deltas, DeploymentPlanningContext ctx) {
        Iterable modifiedSharedLibs = Iterables.transform((Iterable)Iterables.filter((Iterable)deltas.getDeltas(), (Predicate)Predicates.and(Predicates2.operationIs(Operation.MODIFY), Predicates2.deltaOf(Type.valueOf(ExtensibleDeployedSharedLibrary.class)))), Predicates2.extractDeployed());
        for (final Deployed sharedLib : modifiedSharedLibs) {
            List<Deployed> dependentArtifacts = RefreshSharedLibRuntimeDependencies.searchDependentArtifacts(sharedLib, ctx);
            logger.debug("dependentArtifacts: " + dependentArtifacts);
            Iterable runtimeDependenciesDeployedArtifacts = Iterables.filter(dependentArtifacts, (Predicate)new Predicate<Deployed>(){

                public boolean apply(Deployed deployedArtifact) {
                    if (RefreshSharedLibRuntimeDependencies.isArtifactInCurrentDeployment(deltas, deployedArtifact)) {
                        return false;
                    }
                    List sharedLibraries = (List)deployedArtifact.getProperty("sharedLibraries");
                    return sharedLibraries.contains(sharedLib);
                }
            });
            for (Deployed deployed : runtimeDependenciesDeployedArtifacts) {
                logger.debug("%s(%s) Operation.MODIFY", (Object)deployed.getId(), (Object)deployed.getType());
                ExtensibleDeployedArtifact artifact = (ExtensibleDeployedArtifact)ctx.getRepository().read(deployed.getId());
                RuntimeDelta destroyArtifact = new RuntimeDelta(Operation.DESTROY, (Deployed)artifact, null);
                artifact.stopApplication(ctx, destroyArtifact);
                artifact.destroyArtifact(ctx, destroyArtifact);
                RuntimeDelta createArtifact = new RuntimeDelta(Operation.CREATE, null, (Deployed)artifact);
                artifact.deployArtifact(ctx, createArtifact);
                artifact.startApplication(ctx, createArtifact);
            }
        }
    }

    private static boolean isArtifactInCurrentDeployment(Deltas deltas, final Deployed dependentArtifact) {
        Iterable deploymentArtifacts = Iterables.filter((Iterable)Iterables.transform((Iterable)deltas.getDeltas(), Predicates2.extractDeployed()), Predicates2.instanceOf(Type.valueOf(ExtensibleDeployedArtifact.class)));
        return Iterables.any((Iterable)deploymentArtifacts, (Predicate)new Predicate<Deployed>(){

            public boolean apply(Deployed deploymentArtifact) {
                return dependentArtifact.getId().equals(deploymentArtifact.getId());
            }
        });
    }

    private static List<Deployed> searchDependentArtifacts(Deployed deployed, DeploymentPlanningContext context) {
        ImmutableList.Builder builder = new ImmutableList.Builder();
        Repository repository = context.getRepository();
        for (String type : (List)deployed.getProperty("runtimeDependenciesTypes")) {
            builder.addAll((Iterable)repository.search(Type.valueOf((String)type), deployed.getContainer().getId()));
        }
        return builder.build();
    }

    public static class RuntimeDelta
    implements Delta {
        private Operation operation;
        private Deployed previous;
        private Deployed deployed;

        public RuntimeDelta(Operation operation, Deployed previous, Deployed deployed) {
            this.operation = operation;
            this.previous = previous;
            this.deployed = deployed;
        }

        public Operation getOperation() {
            return this.operation;
        }

        public Deployed<?, ?> getPrevious() {
            return this.previous;
        }

        public Deployed<?, ?> getDeployed() {
            return this.deployed;
        }
    }
}

