package com.xebialabs.deployit.plugin.wls.deployed;

import com.xebialabs.deployit.plugin.api.deployment.planning.Create;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.planning.Destroy;
import com.xebialabs.deployit.plugin.api.deployment.planning.Modify;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.Operation;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.wls.container.JmsTarget;
import com.xebialabs.deployit.plugin.wls.resource.JmsResourceSpec;

import static com.google.common.base.Strings.isNullOrEmpty;


@SuppressWarnings("serial")
@Metadata(virtual = true, description = "Base deployed type for all JMS related resources")
public class JmsResource<D extends JmsResourceSpec, C extends JmsTarget> extends BaseWlsDeployed<D, C> {

    @Property(required = true, label="JMS module name", description = "Existing or new Jms system module which will be used to hold this resource")
    private String jmsModuleName;

    @Property(required = true, label="JNDI name", description = "Global JNDI name used to look up the destination within the JNDI namespace")
    private String jndiName;

    @SuppressWarnings("unused")
    @Property(hidden = true, defaultValue = "id, name, type, properties, deployable, container, createScript, createVerb, createOrder, modifyScript, modifyVerb, modifyOrder, destroyScript, " +
            "securityPermissions, inheritPermissions, exposeDeployedApplication, destroyVerb, destroyOrder, jndiName, jmsModuleName, subDeploymentName, restartTarget, libraryScripts, discoverOrder, createOptions, modifyOptions, destroyOptions, noopOptions")
    private String standardPropertiesNotToExpose;

    @Property(required = false, label="Sub-deployment name", description = "Subdeployment name, if null the deployment name is generated by Deployit using the following pattern, ${deployed.jmsModuleName}-subdeployment-for-${deployed.name}")
    private String subDeploymentName;

    @Property(hidden = true, required = false, description = "Python script invoked to create this resource")
    private String createScript;

    @Property(hidden = true, defaultValue = "Create")
    private String createVerb;

    @Property(hidden = true, defaultValue = "60")
    private int createOrder;

    @Property(hidden = true, required = false, description = "Python script invoked to upgrade this resource")
    private String modifyScript;

    @Property(hidden = true, defaultValue = "Upgrade")
    private String modifyVerb;

    @Property(hidden = true, defaultValue = "40")
    private int modifyOrder;

    @Property(hidden = true, required = false, description = "Python script invoked to destroy this resource")
    private String destroyScript;

    @Property(hidden = true, defaultValue = "Destroy")
    private String destroyVerb;

    @Property(hidden = true, defaultValue = "40")
    private int destroyOrder;

    @Create
    public void createResource(DeploymentPlanningContext result, Delta delta) {
        addStepWithCheckpoint(result, delta, Operation.CREATE, createOrder, createScript, createVerb, createOptions);
    }

    @Modify
    public void modifyResource(DeploymentPlanningContext result, Delta delta) {
        if (!isNullOrEmpty(modifyScript)) {
            addStepWithCheckpoint(result, delta, Operation.MODIFY, modifyOrder, modifyScript, modifyVerb, modifyOptions);
        } else {
            destroyResource(result, delta);
            createResource(result, delta);
        }
    }

    @Destroy
    public void destroyResource(DeploymentPlanningContext result, Delta delta) {
        addStepWithCheckpoint(result, delta, Operation.DESTROY, destroyOrder, destroyScript, destroyVerb, destroyOptions);
    }

    public String getJmsModuleName() {
        return jmsModuleName;
    }

    public void setJmsModuleName(String jmsModuleName) {
        this.jmsModuleName = jmsModuleName;
    }

    public String getJndiName() {
        return jndiName;
    }

    public void setJndiName(String jndiName) {
        this.jndiName = jndiName;
    }

    public String getSubDeploymentName() {
        return subDeploymentName;
    }

    public void setSubDeploymentName(String subDeploymentName) {
        this.subDeploymentName = subDeploymentName;
    }
}
