/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wls.contributor;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.plugin.api.deployment.planning.Contributor;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.Deltas;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.udm.DeployableArtifact;
import com.xebialabs.deployit.plugin.wls.container.WlsContainer;
import com.xebialabs.deployit.plugin.wls.deployed.ExtensibleDeployedArtifact;
import com.xebialabs.deployit.plugin.wls.step.MultiTargetDeploymentStep;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiTargetArtifactDeploymentContributor {
    private static final String SINGLE_TARGET_DEPLOYMENT_STEPS = "singleTargetDeploymentSteps";
    protected static final Logger logger = LoggerFactory.getLogger(MultiTargetArtifactDeploymentContributor.class);

    @Contributor
    public static void contributeMultiTargetDeploymentSteps(Deltas allDeltas, DeploymentPlanningContext ctx) {
        Multimap<StepGroupKey, MultiTargetDeploymentStep.StepData> groupedSteps = MultiTargetArtifactDeploymentContributor.groupStepsByOperationAndArtifact(ctx);
        for (StepGroupKey key : groupedSteps.keySet()) {
            MultiTargetDeploymentStep step;
            Collection singleSteps = groupedSteps.get((Object)key);
            if (MultiTargetArtifactDeploymentContributor.isCreateModifyOrDestroyStep(key)) {
                step = MultiTargetArtifactDeploymentContributor.createMultiTargetDeploymentStep(ctx, singleSteps);
                if (step.getDeltas().isEmpty()) {
                    ctx.addStep((Step)step);
                    continue;
                }
                ctx.addStep((Step)step);
                ctx.addCheckpoint((Step)step, step.getDeltas());
                continue;
            }
            if (MultiTargetArtifactDeploymentContributor.isStartStopStep(key)) {
                step = MultiTargetArtifactDeploymentContributor.createMultiTargetDeploymentStep(ctx, singleSteps);
                ctx.addStep((Step)step);
                continue;
            }
            logger.warn("ignore steps not applicable for multi-target deployment {}", (Object)singleSteps);
        }
        ctx.setAttribute(SINGLE_TARGET_DEPLOYMENT_STEPS, new HashSet());
    }

    protected static Multimap<StepGroupKey, MultiTargetDeploymentStep.StepData> groupStepsByOperationAndArtifact(DeploymentPlanningContext ctx) {
        HashMultimap stepsGroupedByOpOnArtifact = HashMultimap.create();
        for (MultiTargetDeploymentStep.StepData target : MultiTargetArtifactDeploymentContributor.getDeploymentSteps(ctx)) {
            stepsGroupedByOpOnArtifact.put((Object)new StepGroupKey(target.getVerb(), target.getOrder(), target.getDeployedArtifact()), (Object)target);
        }
        logger.trace("steps grouped for multi-target deployment {}", (Object)stepsGroupedByOpOnArtifact);
        return stepsGroupedByOpOnArtifact;
    }

    protected static boolean isCreateModifyOrDestroyStep(StepGroupKey key) {
        return key.verb.equals(key.deployed.getCreateVerb()) || key.verb.equals(key.deployed.getModifyVerb()) || key.verb.equals(key.deployed.getDestroyVerb());
    }

    protected static boolean isStartStopStep(StepGroupKey key) {
        return key.verb.equals(key.deployed.getStartVerb()) || key.verb.equals(key.deployed.getStopVerb());
    }

    protected static MultiTargetDeploymentStep createMultiTargetDeploymentStep(DeploymentPlanningContext ctx, Collection<MultiTargetDeploymentStep.StepData> singleTargeSteps) {
        MultiTargetDeploymentStep multiTargetStep = MultiTargetDeploymentStep.create(ctx, singleTargeSteps);
        logger.debug("add multi-target step to plan --> {}", (Object)multiTargetStep.getDescription());
        return multiTargetStep;
    }

    public static void storeDeploymentStep(DeploymentPlanningContext ctx, ExtensibleDeployedArtifact<? extends DeployableArtifact> deployedArtifact, int order, String scriptPath, String verb, Set<String> options, Delta delta) {
        MultiTargetDeploymentStep.StepData target = new MultiTargetDeploymentStep.StepData(deployedArtifact, order, scriptPath, verb, options, delta);
        MultiTargetArtifactDeploymentContributor.getDeploymentSteps(ctx).add(target);
    }

    private static Set<MultiTargetDeploymentStep.StepData> getDeploymentSteps(DeploymentPlanningContext ctx) {
        Set targets = (Set)ctx.getAttribute(SINGLE_TARGET_DEPLOYMENT_STEPS);
        if (targets == null) {
            targets = Sets.newHashSet();
            ctx.setAttribute(SINGLE_TARGET_DEPLOYMENT_STEPS, (Object)targets);
        }
        return targets;
    }

    protected static class StepGroupKey {
        public final String verb;
        public final int order;
        public ExtensibleDeployedArtifact<?> deployed;

        public StepGroupKey(String verb, int order, ExtensibleDeployedArtifact<?> deployed) {
            this.verb = verb;
            this.order = order;
            this.deployed = deployed;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StepGroupKey that = (StepGroupKey)o;
            if (this.order != that.order) {
                return false;
            }
            if (!this.deployed.getName().equals(that.deployed.getName())) {
                return false;
            }
            if (!((WlsContainer)this.deployed.getContainer()).getDomain().getName().equals(((WlsContainer)that.deployed.getContainer()).getDomain().getName())) {
                return false;
            }
            return this.verb.equals(that.verb);
        }

        public int hashCode() {
            int result = this.verb.hashCode();
            result = 31 * result + this.order;
            result = 31 * result + this.deployed.getName().hashCode();
            result = 31 * result + ((WlsContainer)this.deployed.getContainer()).getDomain().getName().hashCode();
            return result;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer("Key{");
            sb.append("verb='").append(this.verb).append('\'');
            sb.append(", order=").append(this.order);
            sb.append(", name=").append(this.deployed.getName());
            sb.append('}');
            return sb.toString();
        }
    }
}

