package com.xebialabs.deployit.plugin.wls.step;

import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.overthere.Host;
import com.xebialabs.deployit.plugin.wls.utils.Closeables;
import com.xebialabs.overthere.OverthereConnection;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.xlplatform.satellite.Satellite;
import com.xebialabs.xlplatform.satellite.SatelliteAware;

@SuppressWarnings("serial")
public class DeleteArtifactStep implements Step, SatelliteAware {

    private final int order;
    private final Host host;
    private final String artifactPath;
    private Host domainHost;

    public DeleteArtifactStep(int order, Host host, String artifactPath, Host domainHost) {
        this.order = order;
        this.host = host;
        this.artifactPath = artifactPath;
        this.domainHost = domainHost;
    }

    @Override
    public String getDescription() {
        return String.format("Delete artifact %s", artifactPath);
    }

    @Override
    public StepExitCode execute(ExecutionContext ctx) throws Exception {
        OverthereConnection connection = host.getConnection();
            OverthereFile fileToDelete = connection.getFile(artifactPath);
            if (fileToDelete.exists()) {
                ctx.logOutput("Deleting " + artifactPath);
            try {
                fileToDelete.delete();
            } finally {
                Closeables.closeQuietly(connection);
            }
                return StepExitCode.SUCCESS;
            } else {
                ctx.logOutput(String.format("Nothing exist at %s, skipping deletion", artifactPath));
                return StepExitCode.SUCCESS;
            }
        }

    @Override
    public int getOrder() {
        return order;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DeleteArtifactStep)) {
            return false;
        }
        DeleteArtifactStep other = (DeleteArtifactStep) obj;
        return host.equals(other.host) && artifactPath.equals(other.artifactPath);
    }

    @Override
    public int hashCode() {
        int result = 17;
        result = 31 * result + host.hashCode();
        result = 31 * result + artifactPath.hashCode();
        return result;
    }

    @Override
    public Satellite getSatellite() {
        Satellite satellite = host.getSatellite();
        if (null == satellite) {
            satellite = domainHost.getSatellite();
        }
        return satellite;
    }



}
