/*
 * Decompiled with CFR 0.152.
 */
package com.crossingchannels.portal.websphere.specification.jee5;

import com.crossingchannels.portal.websphere.specification.jee5.EarDescriptor;
import com.crossingchannels.portal.websphere.specification.jee5.IllegalDescriptorFoundException;
import com.crossingchannels.portal.websphere.specification.jee5.WebArchive;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.local.LocalConnection;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.Validate;

public class EarArchive {
    private final File archiveOnDisk;
    private EarDescriptor earDescriptor = null;
    private final Set<String> webArchives;

    public static EarArchive fromDisk(String location) throws IOException {
        Validate.notNull((Object)location);
        File fileRef = new File(location);
        if (!fileRef.exists() || !fileRef.canRead()) {
            throw new FileNotFoundException(String.format("Unable to read file [%s]", location));
        }
        return new EarArchive(fileRef);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EarArchive(File archive) throws IOException {
        this.archiveOnDisk = archive;
        this.webArchives = new HashSet<String>();
        try (JarFile earFile = new JarFile(archive);){
            Enumeration<JarEntry> jarEntries = earFile.entries();
            while (jarEntries.hasMoreElements()) {
                JarEntry jarEntry = jarEntries.nextElement();
                if (!jarEntry.getName().endsWith(".war")) continue;
                this.webArchives.add(jarEntry.getName());
            }
        }
    }

    public EarDescriptor getDescriptor() throws IllegalDescriptorFoundException, IOException {
        if (this.earDescriptor == null) {
            this.earDescriptor = this.loadDescriptor();
        }
        return this.earDescriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebArchive getWebArchive(String webArchiveURI) throws IOException {
        if (this.webArchives.contains(webArchiveURI)) {
            try (JarFile earFile = new JarFile(this.archiveOnDisk);){
                InputStream stream = earFile.getInputStream(earFile.getEntry(webArchiveURI));
                String temporaryFileName = this.copyToTemporaryFile(stream, webArchiveURI);
                WebArchive webArchive = WebArchive.fromDisk(temporaryFileName);
                return webArchive;
            }
        }
        throw new RuntimeException("illegal web archive requested. URI is unknown");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String copyToTemporaryFile(InputStream stream, String prefix) throws IOException {
        OverthereFile tempFile = LocalConnection.getLocalConnection().getTempFile(prefix, ".war");
        OutputStream outputStream = tempFile.getOutputStream();
        try {
            IOUtils.copy((InputStream)stream, (OutputStream)outputStream);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)outputStream);
        }
        return tempFile.getPath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EarDescriptor loadDescriptor() throws IllegalDescriptorFoundException, IOException {
        JarFile earFile = new JarFile(this.archiveOnDisk);
        InputStream descriptor = earFile.getInputStream(earFile.getJarEntry("META-INF/application.xml"));
        try {
            EarDescriptor earDescriptor = EarDescriptor.fromInputStream(descriptor);
            return earDescriptor;
        }
        finally {
            earFile.close();
        }
    }
}

