/*
 * Decompiled with CFR 0.152.
 */
package com.crossingchannels.portal.websphere.specification.jsr286;

import com.crossingchannels.portal.websphere.specification.jee5.IllegalDescriptorFoundException;
import com.crossingchannels.portal.websphere.specification.jsr286.dom.ObjectFactory;
import com.crossingchannels.portal.websphere.specification.jsr286.dom.PortletAppType;
import com.crossingchannels.portal.websphere.specification.jsr286.dom.PortletType;
import com.crossingchannels.portal.websphere.util.ChangeNamespaceXmlFilter;
import com.crossingchannels.portal.websphere.util.UnexpectedXmlElementException;
import com.crossingchannels.portal.websphere.util.XmlUtil;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.xml.bind.JAXBException;
import org.apache.commons.lang.Validate;

public class PortletDescriptor {
    private static final Set<String> COMPATIBLE_NAMESPACES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("http://java.sun.com/xml/ns/portlet/portlet-app_1_0.xsd", "http://java.sun.com/xml/ns/portlet/portlet-app_2_0.xsd")));
    private static final String TARGET_NAMESPACE = "http://java.sun.com/xml/ns/portlet/portlet-app_2_0.xsd";
    private String name;
    private String uniqueIdentifier;
    private Set<String> portletNames;

    public static final PortletDescriptor fromInputStream(InputStream portletXmlInputStream) throws IllegalDescriptorFoundException {
        PortletAppType domApplication;
        Validate.notNull((Object)portletXmlInputStream);
        try {
            domApplication = XmlUtil.loadDom(portletXmlInputStream, ObjectFactory.class.getPackage(), PortletAppType.class, new ChangeNamespaceXmlFilter(TARGET_NAMESPACE, COMPATIBLE_NAMESPACES));
        }
        catch (JAXBException e) {
            throw new IllegalDescriptorFoundException("Portlet descriptor contains invalid XML", e);
        }
        catch (UnexpectedXmlElementException e) {
            throw new IllegalDescriptorFoundException("Portlet descriptor contains illegal XML root element", e);
        }
        PortletDescriptor portletDescriptor = new PortletDescriptor();
        portletDescriptor.setUniqueIdentifier(domApplication.getId());
        portletDescriptor.setName(domApplication.getId());
        HashSet<String> portletNames = new HashSet<String>();
        for (PortletType domPortlet : domApplication.getPortlet()) {
            portletNames.add(domPortlet.getPortletName().getValue().trim());
        }
        portletDescriptor.setPortletNames(portletNames);
        return portletDescriptor;
    }

    public String getName() {
        return this.name;
    }

    public String getUniqueIdentifier() {
        return this.uniqueIdentifier;
    }

    public Set<String> getPortletNames() {
        return this.portletNames;
    }

    private void setName(String name) {
        this.name = name;
    }

    private void setUniqueIdentifier(String uniqueIdentifier) {
        this.uniqueIdentifier = uniqueIdentifier;
    }

    private void setPortletNames(Set<String> portletNames) {
        this.portletNames = Collections.unmodifiableSet(portletNames);
    }
}

