/*
 * Decompiled with CFR 0.152.
 */
package com.crossingchannels.portal.websphere.template;

import com.crossingchannels.portal.websphere.template.TemplateParseException;
import com.crossingchannels.portal.websphere.template.TemplateParser;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseFreemarkerTemplateParser
implements TemplateParser {
    public static final String VAR_DEPLOYED_CI = "deployed";
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseFreemarkerTemplateParser.class);
    private final Configuration freemarkerConfiguration;

    protected BaseFreemarkerTemplateParser(Configuration freemarkerConfiguration) {
        this.freemarkerConfiguration = freemarkerConfiguration;
    }

    protected BaseFreemarkerTemplateParser() {
        this.freemarkerConfiguration = null;
    }

    @Override
    public void parse(String templateName, Map<String, ?> context, OutputStream out) throws TemplateParseException {
        Validate.notEmpty((String)templateName);
        Validate.notNull(context);
        Validate.notNull((Object)out);
        try {
            Template template = this.freemarkerConfiguration.getTemplate(templateName);
            template.process(context, (Writer)new OutputStreamWriter(out));
        }
        catch (IOException ioe) {
            LOGGER.error(String.format("Unable to read/find template [%s]", templateName), (Throwable)ioe);
            throw new TemplateParseException(templateName, ioe);
        }
        catch (TemplateException te) {
            LOGGER.error(String.format("Unable to parse template [%s]", templateName), (Throwable)te);
            throw new TemplateParseException(templateName, te);
        }
    }

    @Override
    public void parse(String templateName, Deployed<?, ?> deployedCi, Map<String, ?> context, OutputStream out) throws TemplateParseException {
        Validate.notNull((Object)templateName);
        Validate.notNull(deployedCi);
        Validate.notNull(context);
        Validate.notNull((Object)out);
        HashMap mergedContext = new HashMap(context);
        mergedContext.put(VAR_DEPLOYED_CI, deployedCi);
        this.parse(templateName, mergedContext, out);
    }
}

