package com.crossingchannels.portal.websphere.template;

import java.io.File;
import java.io.IOException;

import com.crossingchannels.portal.websphere.util.InternalPluginException;
import com.xebialabs.deployit.plugin.generic.freemarker.ConfigurationHolder;

import freemarker.template.Configuration;

/**
 * An implementation of {@link BaseFreemarkerTemplateParser} that will parse freemarker templates located on the filesystem.
 * 
 * @author FWiegerinck
 */
public class FreemarkerTemplateOnFilesystemParser extends BaseFreemarkerTemplateParser {


	/**
	 * Define instance of the parser.
	 */
	public static final FreemarkerTemplateOnFilesystemParser INSTANCE = new FreemarkerTemplateOnFilesystemParser();

	private static final Configuration buildFreemarkerConfiguration() {

        final Configuration newConfiguration = (Configuration) ConfigurationHolder.getConfiguration().clone();
        try {
        	newConfiguration.setDirectoryForTemplateLoading(new File("."));
        } catch(IOException ioe) {
        	throw new InternalPluginException("Unable to set template directory for filesystem repositories", ioe);
        }

        return newConfiguration;
    }

    /**
     * Initialize a new parser to parse freemarker templates located on the filesystem.
     */
    private FreemarkerTemplateOnFilesystemParser() {
        super(FreemarkerTemplateOnFilesystemParser.buildFreemarkerConfiguration());
    }    

}
