package com.crossingchannels.portal.websphere.ci.base.contributor;

import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.was.deployed.ExtensibleDeployedArtifact;

/**
 * Abstract contributor to add additional steps for (un)installation of WAS artifacts.
 * 
 * @author fwiegerinck
 * @since 1.1
 * @version 1.1
 */
public abstract class AbstractWasArtifactStepsContributor extends AbstractStepsContributor<ExtensibleDeployedArtifact> {

	/**
	 * Define type for 'wp.WpRuntimeContainer';
	 */
    private static final Type TYPE_WPRUNTIMECONTAINER = Type.valueOf("wp.WpRuntimeContainer");;

	/**
     * Initialize new abstract contributor.
     * 
     * @param baseCiType
     *            Base CI type.
     */
    protected AbstractWasArtifactStepsContributor(final Type baseCiType) {
        super(baseCiType, AbstractWasArtifactStepsContributor.TYPE_WPRUNTIMECONTAINER);
    }

}
