package com.crossingchannels.portal.websphere.ci.portlet.model;

import java.util.Set;

import org.apache.commons.lang.Validate;

import ext.deployit.com.crossingchannels.portal.websphere.ci.portlet.deployed.BasePortlet;

/**
 * @author FWiegerinck
 */
@SuppressWarnings("serial")
public class Portlet extends BasePortletModel {

    private final String name;
    private final String idSafeName;
	private final Set<ClonedPortlet> clonedPortlets;

    /**
     * @param name
     * @param portletCi The portlet CI
     * @param clonedPortlets 
     */
    Portlet(final String name, final BasePortlet<?,?> portletCi, final Set<ClonedPortlet> clonedPortlets) {
        super(portletCi);
        
        // Preconditions
        Validate.notEmpty(name);
        Validate.notNull(clonedPortlets);
        
        // Store values
        this.name = name;
        this.idSafeName = name.replace(' ', '_');
        this.clonedPortlets = clonedPortlets;
    }

    public String getName() {
        return this.name;
    }
    
    public Set<ClonedPortlet> getClones() {
    	return this.clonedPortlets;
    }
    
    public String getIdSafeName() {
    	return this.idSafeName;
    }

}
