package ext.deployit.com.crossingchannels.portal.websphere.ci.themesandskins.contributor;

import com.crossingchannels.portal.websphere.ci.base.contributor.AbstractWasArtifactStepsContributor;
import com.crossingchannels.portal.websphere.ci.base.util.CastHelper;
import com.xebialabs.deployit.plugin.api.deployment.planning.Contributor;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.Deltas;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.was.deployed.ExtensibleDeployedArtifact;

import ext.deployit.com.crossingchannels.portal.websphere.ci.generic.container.WpContainer;
import ext.deployit.com.crossingchannels.portal.websphere.ci.generic.step.ExecuteXmlAccessConfigurationItemStep;

/**
 * Contributor to add additional steps when a WAR with themes and skins are installed.
 * 
 * @author fwiegerinck
 * @since 1.1
 * @version 1.1
 */
public class ThemesAndSkinsWarStepsContributor extends AbstractWasArtifactStepsContributor {

    /**
     * Resolve type definition for a portlet Ear.
     */
    private static final Type THEMESANDSKINSWAR = Type.valueOf("wp.ThemesAndSkinsWarModule");

    /**
     * Define name of the CI-property containing the register XML Access Script.
     */
    private static final String PROPERTY_REGISTER_SCRIPT = "createXmlAccessScript";

    /**
     * Define name of the CI-property containing the unregister XML Access Script.
     */
    private static final String PROPERTY_UNREGISTER_SCRIPT = "destroyXmlAccessScript";

    /**
     * Define name of the CI-property containing the order to run the register script.
     */
    private static final String PROPERTY_REGISTER_ORDER = "createXmlAccessOrder";

    /**
     * Define name of the CI-property containing the order to run the unregister script.
     */
    private static final String PROPERTY_UNREGISTER_ORDER = "destroyXmlAccessOrder";

    /**
     * Initialize a new installation steps contributor for Portlet EARs
     */
    public ThemesAndSkinsWarStepsContributor() {
        super(ThemesAndSkinsWarStepsContributor.THEMESANDSKINSWAR);
    }

    // Override to trigger autodetection
    @Override
    @Contributor
    public void contributePortletSteps(final Deltas deltas, final DeploymentPlanningContext context) {
        super.contributePortletSteps(deltas, context);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected void install(final ExtensibleDeployedArtifact artifactToInstall, final DeploymentPlanningContext context, final Delta delta) {
        // Add required steps
        context.addStep( new ExecuteXmlAccessConfigurationItemStep(artifactToInstall.<String> getProperty(ThemesAndSkinsWarStepsContributor.PROPERTY_REGISTER_SCRIPT), castArtifact(artifactToInstall),
        		artifactToInstall.<Integer> getProperty(ThemesAndSkinsWarStepsContributor.PROPERTY_REGISTER_ORDER)));
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected void update(final ExtensibleDeployedArtifact newArtifact, final ExtensibleDeployedArtifact oldArtifact, final DeploymentPlanningContext context, final Delta delta) {
    	// Installs and updates are the same
        this.install(newArtifact, context, delta);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected void uninstall(final ExtensibleDeployedArtifact artifactToUninstall, final DeploymentPlanningContext context, final Delta delta) {
        // Add required steps
        context.addStep( new ExecuteXmlAccessConfigurationItemStep(artifactToUninstall.<String> getProperty(ThemesAndSkinsWarStepsContributor.PROPERTY_UNREGISTER_SCRIPT), castArtifact(artifactToUninstall),
        		artifactToUninstall.<Integer> getProperty(ThemesAndSkinsWarStepsContributor.PROPERTY_UNREGISTER_ORDER)));
    }

	private Deployed<? extends Deployable, ? extends WpContainer> castArtifact(ExtensibleDeployedArtifact artifact) {
    	return CastHelper.cast(artifact);
    }
}
