/*
 * Decompiled with CFR 0.152.
 */
package com.crossingchannels.portal.websphere.ci.portlet.model;

import com.crossingchannels.portal.websphere.ci.portlet.model.PortletArchive;
import com.crossingchannels.portal.websphere.ci.portlet.model.WebModule;
import com.crossingchannels.portal.websphere.ci.portlet.model.WebModuleBuilder;
import com.crossingchannels.portal.websphere.model.AbstractModelElementFactory;
import com.crossingchannels.portal.websphere.specification.jee5.EarArchive;
import com.crossingchannels.portal.websphere.specification.jee5.EarDescriptor;
import com.crossingchannels.portal.websphere.specification.jee5.IllegalDescriptorFoundException;
import com.crossingchannels.portal.websphere.specification.jee5.WebArchive;
import com.xebialabs.deployit.plugin.api.udm.DeployableArtifact;
import com.xebialabs.deployit.plugin.was.deployed.ExtensibleDeployedArtifact;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortletArchiveBuilder
extends AbstractModelElementFactory<PortletArchive> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PortletArchiveBuilder.class);
    private static final Pattern WEBSPHERE_VARIABLE_PATTERN = Pattern.compile("\\$\\((.*)\\)");
    private static final String CI_ATTR_WAR_CONTEXTROOT = "contextRoot";
    private static final String CI_ATTR_ARCHIVE_AUTOSCAN = "autoScanForPortlets";
    private final ExtensibleDeployedArtifact artifactToInstall;
    private final Map<String, String> webModulesMapping;
    private final Map<String, WebArchive> webArchives;

    public static PortletArchiveBuilder fromEar(ExtensibleDeployedArtifact artifactToInstall) {
        return new PortletArchiveBuilder(artifactToInstall).initializeAsEar();
    }

    public static PortletArchiveBuilder fromWar(ExtensibleDeployedArtifact artifactToInstall) {
        return new PortletArchiveBuilder(artifactToInstall).initializeAsWar();
    }

    private PortletArchiveBuilder(ExtensibleDeployedArtifact artifactToInstall) {
        this.artifactToInstall = artifactToInstall;
        this.webModulesMapping = new HashMap<String, String>();
        this.webArchives = new HashMap<String, WebArchive>();
    }

    private PortletArchiveBuilder initializeAsEar() {
        try {
            EarArchive earArchive = EarArchive.fromDisk(((DeployableArtifact)this.artifactToInstall.getDeployable()).getFile().getPath());
            EarDescriptor earDescriptor = earArchive.getDescriptor();
            for (String webArchiveURI : earDescriptor.getWebArchiveURIs()) {
                this.webModulesMapping.put(webArchiveURI, earDescriptor.getWebArchiveContextRoot(webArchiveURI));
                this.webArchives.put(webArchiveURI, earArchive.getWebArchive(webArchiveURI));
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot open EAR archive from repo", e);
        }
        catch (IllegalDescriptorFoundException e) {
            throw new RuntimeException("Cannot open EAR descriptor from EAR in repo", e);
        }
        return this;
    }

    private PortletArchiveBuilder initializeAsWar() {
        String contextRoot = (String)this.artifactToInstall.getProperty(CI_ATTR_WAR_CONTEXTROOT);
        String archiveName = ((DeployableArtifact)this.artifactToInstall.getDeployable()).getFile().getName();
        LOGGER.trace("Use WAR filename [{}] for deployment of CI [{}]", (Object)archiveName, (Object)this.artifactToInstall.getId());
        this.webModulesMapping.put(archiveName, contextRoot);
        try {
            this.webArchives.put(archiveName, WebArchive.fromDisk(((DeployableArtifact)this.artifactToInstall.getDeployable()).getFile().getPath()));
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot open WAR archive from repo", e);
        }
        return this;
    }

    protected String getApplicationInstallDirectory() {
        if (this.artifactToInstall.hasProperty("installLocation")) {
            return (String)this.artifactToInstall.getProperty("installLocation");
        }
        return null;
    }

    @Override
    public PortletArchive toModel() {
        String locationOnDisk = PortletArchiveBuilder.reformatVariables(this.getApplicationInstallDirectory());
        ArrayList<WebModule> webModules = new ArrayList<WebModule>();
        boolean autoScanForPortlets = (Boolean)ObjectUtils.defaultIfNull((Object)this.artifactToInstall.getProperty(CI_ATTR_ARCHIVE_AUTOSCAN), (Object)Boolean.FALSE);
        Set portlets = (Set)this.artifactToInstall.getProperty("portlets");
        for (String webArchiveURI : this.webModulesMapping.keySet()) {
            String webModuleLocationOnDisk = locationOnDisk != null ? locationOnDisk + "/" + webArchiveURI : null;
            try {
                webModules.add(WebModuleBuilder.create(webModuleLocationOnDisk, this.webModulesMapping.get(webArchiveURI)).use(this.webArchives.get(webArchiveURI), portlets, autoScanForPortlets).toModel());
            }
            catch (IllegalDescriptorFoundException e) {
                throw new RuntimeException("Cannot process EAR archive from repo", e);
            }
            catch (IOException e) {
                throw new RuntimeException("Cannot process EAR archive from repo", e);
            }
        }
        return new PortletArchive(locationOnDisk, webModules);
    }

    private static String reformatVariables(String value) {
        if (value == null) {
            return null;
        }
        Matcher m = WEBSPHERE_VARIABLE_PATTERN.matcher(value);
        StringBuffer result = new StringBuffer();
        while (m.find()) {
            m.appendReplacement(result, "\\$" + m.group(1).toLowerCase() + "\\$");
        }
        m.appendTail(result);
        return result.toString();
    }
}

