/*
 * Decompiled with CFR 0.152.
 */
package ext.deployit.com.crossingchannels.portal.websphere.ci.generic.deployed;

import com.xebialabs.deployit.plugin.api.deployment.planning.Create;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.planning.Destroy;
import com.xebialabs.deployit.plugin.api.deployment.planning.Modify;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.udm.ControlTask;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseDeployedArtifact;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.local.LocalFile;
import ext.deployit.com.crossingchannels.portal.websphere.ci.generic.container.WpContainer;
import ext.deployit.com.crossingchannels.portal.websphere.ci.generic.deployable.DeployableXmlAccessScript;
import ext.deployit.com.crossingchannels.portal.websphere.ci.generic.step.ExecuteXmlAccessScriptStep;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(virtual=false, description="Deployed XML Access script")
public class DeployedXmlAccessScript
extends BaseDeployedArtifact<DeployableXmlAccessScript, WpContainer> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeployedXmlAccessScript.class);
    @Property(hidden=false, label="Create script", description="XML Access Script used to install. Also used during update if no update script is specified.", category="Advanced")
    private String createScript;
    @Property(hidden=false, label="Destroy script", description="XML Access Script used to uninstall. Also used during update if no update script is specified.", category="Advanced", required=false)
    private String destroyScript;
    @Property(hidden=false, label="Modify script", description="XML Access Script used to update from a previous version.", category="Advanced", required=false)
    private String modifyScript;
    @Property(hidden=true, label="Order of creation", defaultValue="79")
    private int createOrder;
    @Property(hidden=true, label="Order of destruction", defaultValue="21", required=false)
    private int destroyOrder;
    @Property(hidden=true, label="Order of modification", defaultValue="21", required=false)
    private int modifyOrder;

    public String getCreateScript() {
        return this.createScript;
    }

    public void setCreateScript(String create) {
        this.createScript = create;
    }

    public String getDestroyScript() {
        return this.destroyScript;
    }

    public void setDestroyScript(String destroy) {
        this.destroyScript = destroy;
    }

    public String getModifyScript() {
        return this.modifyScript;
    }

    public void setModifyScript(String modify) {
        this.modifyScript = modify;
    }

    public int getCreateOrder() {
        return this.createOrder;
    }

    public void setCreateOrder(int createOrder) {
        this.createOrder = createOrder;
    }

    public int getDestroyOrder() {
        return this.destroyOrder;
    }

    public void setDestroyOrder(int destroyOrder) {
        this.destroyOrder = destroyOrder;
    }

    public int getModifyOrder() {
        return this.modifyOrder;
    }

    public void setModifyOrder(int modifyOrder) {
        this.modifyOrder = modifyOrder;
    }

    @Create
    public void createResource(DeploymentPlanningContext ctx) throws IOException {
        if (StringUtils.isNotEmpty((String)this.createScript)) {
            this.addStep(ctx, this.createScript, this.createOrder);
        }
    }

    @Modify
    public void modifyResource(DeploymentPlanningContext ctx) throws IOException {
        if (StringUtils.isNotEmpty((String)this.modifyScript)) {
            this.addStep(ctx, this.modifyScript, this.modifyOrder);
        } else {
            this.destroyResource(ctx);
            this.createResource(ctx);
        }
    }

    @Destroy
    public void destroyResource(DeploymentPlanningContext ctx) throws IOException {
        if (StringUtils.isNotEmpty((String)this.destroyScript)) {
            this.addStep(ctx, this.destroyScript, this.destroyOrder);
        }
    }

    protected void addStep(DeploymentPlanningContext ctx, String script, int order) throws IOException {
        String locatedFile = this.locateFile(script);
        if (StringUtils.isNotEmpty((String)locatedFile)) {
            ctx.addStep((Step)new ExecuteXmlAccessScriptStep(locatedFile, order, this));
        } else {
            LOGGER.error("Unable to locate script: {}", (Object)script);
        }
    }

    @ControlTask(description="Reinstall the XML Access script")
    public List<? extends Step> reinstall() throws IOException {
        return Collections.singletonList(new ExecuteXmlAccessScriptStep(this.createScript, this.createOrder, this));
    }

    private String locateFile(String filter) {
        Validate.notEmpty((String)filter);
        List files = this.getFile().listFiles();
        for (OverthereFile file : files) {
            if (!filter.equals(file.getName()) || !(file instanceof LocalFile)) continue;
            String filename = file.getPath();
            LOGGER.debug("Found file [{}]", (Object)filename);
            return filename;
        }
        return null;
    }
}

