package com.crossingchannels.portal.websphere.template;

import java.io.OutputStream;
import java.util.Map;

import com.xebialabs.deployit.plugin.api.udm.Deployed;

/**
 * Interface definition for a template parser.
 * 
 * @author FWiegerinck
 */
public interface TemplateParser {

    /**
     * Parse the template identified by the <code>templateName</code> using the parameters provided by the <code>context</code>. The output is send to the outputstream <code>out</code>.
     * 
     * @param templateName
     *            Name of the template to parse.
     * @param context
     *            The context with parameters/variables using during parsing.
     * @param out
     *            The output stream that will contain the parsed template.
     * @throws TemplateParseException
     *             Thrown if an error occurs while parsing the template.
     */
    void parse(final String templateName, final Map<String, ?> context, final OutputStream out) throws TemplateParseException;

    /**
     * Parse the template identified by the <code>templateName</code> using deployed CI and the parameters provided by the <code>context</code>. The output is send to the outputstream <code>out</code>
     * .
     * 
     * @param templateName
     *            Name of the template to parse.
     * @param deployedCi
     *            The deployed CI used during parsing.
     * @param context
     *            The context with parameters/variables using during parsing.
     * @param out
     *            The output stream that will contain the parsed template.
     * @throws TemplateParseException
     *             Thrown if an error occurs while parsing the template.
     */
    void parse(final String templateName, final Deployed<?, ?> deployedCi, final Map<String, ?> context, final OutputStream out) throws TemplateParseException;

}
