/*
 * Decompiled with CFR 0.152.
 */
package com.crossingchannels.portal.websphere.ci.portlet.model;

import com.crossingchannels.portal.websphere.ci.portlet.model.PortletApplication;
import com.crossingchannels.portal.websphere.ci.portlet.model.PortletApplicationBuilder;
import com.crossingchannels.portal.websphere.ci.portlet.model.WebModule;
import com.crossingchannels.portal.websphere.model.AbstractModelElementFactory;
import com.crossingchannels.portal.websphere.specification.jee5.IllegalDescriptorFoundException;
import com.crossingchannels.portal.websphere.specification.jee5.WebArchive;
import ext.deployit.com.crossingchannels.portal.websphere.ci.portlet.deployed.BasePortlet;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import org.apache.commons.lang.Validate;

public class WebModuleBuilder
extends AbstractModelElementFactory<WebModule> {
    private final String locationOnDisk;
    private final String contextRoot;
    private String displayName;
    private String uniqueIdentifier;
    private PortletApplication portletApplication;

    public static WebModuleBuilder create(String locationOnDisk, String contextRoot) {
        return new WebModuleBuilder(locationOnDisk, contextRoot);
    }

    private WebModuleBuilder(String locationOnDisk, String contextRoot) {
        this.locationOnDisk = locationOnDisk;
        this.contextRoot = contextRoot;
    }

    public WebModuleBuilder use(WebArchive webArchive, Set<BasePortlet<?, ?>> portlets, boolean autoScanForPortlets) throws IllegalDescriptorFoundException, IOException {
        this.displayName = webArchive.getDescriptor().getDisplayName();
        if (this.displayName == null) {
            String webArchiveName = webArchive.getArchiveName();
            this.displayName = webArchiveName.substring(0, webArchiveName.lastIndexOf("."));
        }
        this.uniqueIdentifier = webArchive.getDescriptor().getUniqueIdentifier();
        this.portletApplication = PortletApplicationBuilder.create(webArchive.getPortletDescriptor()).withPortlets(portlets, autoScanForPortlets).toModel();
        return this;
    }

    @Override
    public WebModule toModel() {
        Validate.notNull((Object)this.contextRoot);
        Validate.notNull((Object)this.displayName);
        return new WebModule(this.locationOnDisk, this.contextRoot, this.displayName, this.uniqueIdentifier, Collections.singletonList(this.portletApplication));
    }
}

