/*
 * Decompiled with CFR 0.152.
 */
package com.crossingchannels.portal.websphere.specification.jee5;

import com.crossingchannels.portal.websphere.specification.jee5.IllegalDescriptorFoundException;
import com.crossingchannels.portal.websphere.specification.jee5.dom.DisplayNameType;
import com.crossingchannels.portal.websphere.specification.jee5.dom.ObjectFactory;
import com.crossingchannels.portal.websphere.specification.jee5.dom.WebAppType;
import com.crossingchannels.portal.websphere.util.ChangeNamespaceXmlFilter;
import com.crossingchannels.portal.websphere.util.UnexpectedXmlElementException;
import com.crossingchannels.portal.websphere.util.XmlUtil;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;

public class WebDescriptor {
    private static final Set<String> COMPATIBLE_NAMESPACES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("http://java.sun.com/xml/ns/javaee", "http://java.sun.com/xml/ns/j2ee")));
    private static final String TARGET_NAMESPACE = "http://java.sun.com/xml/ns/javaee";
    private String displayName;
    private String uniqueIdentifier;

    public static final WebDescriptor fromInputStream(InputStream webXmlInputStream) throws IllegalDescriptorFoundException {
        WebAppType domApplication;
        Validate.notNull((Object)webXmlInputStream);
        try {
            domApplication = XmlUtil.loadDom(webXmlInputStream, ObjectFactory.class.getPackage(), WebAppType.class, new ChangeNamespaceXmlFilter(TARGET_NAMESPACE, COMPATIBLE_NAMESPACES));
        }
        catch (JAXBException e) {
            throw new IllegalDescriptorFoundException("WAR descriptor contains invalid XML", e);
        }
        catch (UnexpectedXmlElementException e) {
            throw new IllegalDescriptorFoundException("WAR descriptor contains illegal XML root element", e);
        }
        WebDescriptor webDescriptor = new WebDescriptor();
        webDescriptor.setUniqueIdentifier(domApplication.getId());
        for (JAXBElement<?> element : domApplication.getDescriptionAndDisplayNameAndIcon()) {
            DisplayNameType displayNameType;
            Object value = element.getValue();
            if (!(value instanceof DisplayNameType) || !StringUtils.isEmpty((String)(displayNameType = (DisplayNameType)DisplayNameType.class.cast(value)).getLang())) continue;
            webDescriptor.setDisplayName(displayNameType.getValue());
        }
        return webDescriptor;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getUniqueIdentifier() {
        return this.uniqueIdentifier;
    }

    public void setUniqueIdentifier(String uniqueIdentifier) {
        this.uniqueIdentifier = uniqueIdentifier;
    }
}

