package ext.deployit.com.crossingchannels.portal.websphere.ci.generic.container;

import com.crossingchannels.portal.websphere.ci.generic.container.WpVersion;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;

/**
 * CI container to represent an unmanaged server instance. This CI is an extension of the <code>UnmanagedServer</code> as defined within the WAS plugin.
 * 
 * @author fwiegerinck
 */
@Metadata(description = "A standalone WebSphere Portal server NOT managed by any deployment manager", inspectable = true)
@SuppressWarnings("serial")
public class UnmanagedServer extends com.xebialabs.deployit.plugin.was.container.UnmanagedServer implements WpRuntimeContainer {

    @Property(label = "Version", description = "The version of WebSphere Portal.", category = "Portal", required = true)
    private WpVersion wpVersion;

    @Property(label = "Installation location", description = "Location of WebSphere Portal..", category = "Portal", required = true)
    private String wpHome;

    @Property(label = "Administrative user", description = "Username of the administrative user.", category = "Portal", required = true)
    private String wpAdminUsername;

    @Property(label = "Administrative password", description = "Password of the administrative user.", category = "Portal", required = true, password = true)
    private String wpAdminPassword;

    @Property(label = "Configuration URL", description = "The URL of the WebSphere Portal configuration API.", category = "Portal", required = true)
    private String wpConfigUrl;

    /**
     * {@inheritDoc}
     */
    @Override
    public WpVersion getWpVersion() {
        return this.wpVersion;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String getWpHome() {
        return this.wpHome;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String getWpAdminUsername() {
        return this.wpAdminUsername;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String getWpAdminPassword() {
        return this.wpAdminPassword;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String getWpConfigUrl() {
        return this.wpConfigUrl;
    }

    public void setWpVersion(final WpVersion wpVersion) {
        this.wpVersion = wpVersion;
    }

    public void setWpHome(final String wpHome) {
        this.wpHome = wpHome;
    }

    public void setWpAdminUsername(final String wpAdminUsername) {
        this.wpAdminUsername = wpAdminUsername;
    }

    public void setWpAdminPassword(final String wpAdminPassword) {
        this.wpAdminPassword = wpAdminPassword;
    }

    public void setWpConfigUrl(final String wpConfigUrl) {
        this.wpConfigUrl = wpConfigUrl;
    }

    @Override
    public WpRuntimeContainer getRuntimeContainer() {
        return this;
    }
}
