
#*******************************************************************************************************
# convert a string as returned by AdminConfig.show[Attribute] to a Jython list
#*******************************************************************************************************
def wsadminToList(inStr):
  outList=[]
  if (len(inStr)>0 and inStr[0]=='[' and inStr[-1]==']'):
    inStr = inStr[1:-1]
    tmpList = inStr.split(" ")
  else:
    tmpList = inStr.split("\n")	 #splits for Windows or Linux
  for item in tmpList:
    item = item.rstrip();		 #removes any Windows "\r"
    if (len(item)>0):
      outList.append(item)
  return outList
#endDef

#*******************************************************************************************************
# convert a configuration id to a containment path
# sample : claimsHandlingProcess(cells/vienna/applications/BPELClaimsHandling.ear/deployments/BPELClaimsHandling|deployment-bpc.xml#ProcessComponent_1073642403600)
#*******************************************************************************************************

def idToContainmentPath(id):
    return id[id.index("(")+1:id.index("|")]


#*******************************************************************************************************
# find unique deployment target for the application in the container
#*******************************************************************************************************

def findDeploymentTarget(appName, containerName):
  deployment = AdminConfig.getid("/Deployment:%s/" % (appName))
  deploymentTargets = wsadminToList(AdminConfig.showAttribute(deployment, "deploymentTargets"))
  appDeployment = ""
  for deploymentTarget in deploymentTargets:
    if (deploymentTarget.startswith(containerName)):
        appDeployment = deploymentTarget
        break;

  if (appDeployment == ""):
    print "Application " + appName + " cannot be found on container " + containerName
    sys.exit(1)

  return appDeployment

#*******************************************************************************************************
# Find the BPC MBeans to connect to.
#*******************************************************************************************************

def findBPCMBeans(container):
    bfmMBeans = []
    htmMBeans = []
    if (container.wasTargetType == "cluster"):
        cluster = AdminConfig.getid("%s%s/" %(container.cell.containmentPath, container.containmentPath))
        for member in AdminConfig.list("ClusterMember", cluster ).splitlines():
            nodeName = AdminConfig.showAttribute(member, "nodeName" )
            serverName = AdminConfig.showAttribute(member, "memberName" )
            bfmMBean = AdminControl.completeObjectName("type=InternalProcessContainer,node="+nodeName+",process="+serverName+",*" )
            if (bfmMBean != ""):
                bfmMBeans.append(bfmMBean)
            #endIf
            htmMBean = AdminControl.completeObjectName("type=InternalTaskManager,node="+nodeName+",process="+serverName+",*" )
            if (htmMBean != ""):
                htmMBeans.append(htmMBean)
            #endIf
        #endFor
    else:
        nodeName = container.node.name
        serverName = container.name
        bfmMBean = AdminControl.completeObjectName("type=InternalProcessContainer,node="+nodeName+",process="+serverName+",*" )
        if (bfmMBean != ""):
            bfmMBeans.append(bfmMBean)
        #endIf
        htmMBean = AdminControl.completeObjectName("type=InternalTaskManager,node="+nodeName+",process="+serverName+",*" )
        if (htmMBean != ""):
            htmMBeans.append(htmMBean)
        #endIf
    #endElse

    return {"processMBeans":bfmMBeans, "taskMBeans":htmMBeans}



#*******************************************************************************************************
# Change the state for all process templates of a given enterprise application
#*******************************************************************************************************

def changeProcessTemplateState(deploymentTargetId, processMBeans, processMethod, state, wasVersion):
    #convert deployment configuration id to containment path.
    deploymentContainmentPath =	 idToContainmentPath(deploymentTargetId)
    templates = []
    print "Loading processes..."
    for template in wsadminToList(AdminConfig.list("ProcessComponent")):
        if (deploymentContainmentPath == idToContainmentPath(template)):
            templates.append(template)
        #endIf
    #endFor

    if (len(templates) == 0):
        print "No process templates found."
    elif (len(processMBeans) == 0):
        print "Error: Could not find a ProcessContainer MBean"
        sys.exit(1)
    else:
        # For each template, update the state in both the Process Choreographer database
        # and in the WebSphere configuration (which is used by the Admin Console).
        for template in templates:
            templateName = AdminConfig.showAttribute(template, "name")
            templateValidFrom = AdminConfig.showAttribute(template, "validFrom")
            print "Changing template instance '%s' state to '%s' in Process Choreographer database" % (templateName, state)
            for bfmMBean in processMBeans:
                if wasVersion == "WAS_61":
                    AdminControl.invoke(bfmMBean, processMethod, "[%s,%s]" % (templateName, templateValidFrom))
                else:
                    AdminControl.invoke(bfmMBean, processMethod, [templateName, templateValidFrom])
            #endFor
            print "Changing template '%s' state to '%s' in Websphere configuration" % (template, state)
            AdminConfig.modify(AdminConfig.showAttribute(template, "stateManagement" ), [["initialState", state]] )
        #endFor
    #endElse

#*******************************************************************************************************
# Change the state for all task templates of a given enterprise application
#*******************************************************************************************************

def changeTaskTemplateState(deploymentTargetId, taskMBeans, taskMethod, state, wasVersion):
    #convert deployment configuration id to containment path.
    deploymentContainmentPath =	 idToContainmentPath(deploymentTargetId)
    templates = []
    print "Loading tasks..."
    for template in wsadminToList(AdminConfig.list("TaskComponent")):
        if (deploymentContainmentPath == idToContainmentPath(template)):
            templates.append(template)
        #endIf
    #endFor

    if (len(templates) == 0):
        print "No task templates found."
    elif (len(taskMBeans) == 0):
        print "Error: Could not find a TaskManager MBean"
        sys.exit(1)
    else:
        # For each template, update the state in both the Process Choreographer database
        # and in the WebSphere configuration (which is used by the Admin Console).
        for template in templates:
            templateName = AdminConfig.showAttribute(template, "name")
            templateValidFrom = AdminConfig.showAttribute(template, "validFrom")
            templateNamespace = AdminConfig.showAttribute(template, "namespace")
            print "Changing template instance '%s' state to '%s' in Process Choreographer database" % (templateName, state)
            for mbean in taskMBeans:
                if wasVersion == "WAS_61":
                    AdminControl.invoke(mbean, taskMethod, "[%s,%s,%s]" % (templateName, templateValidFrom, templateNamespace) )
                else:
                    AdminControl.invoke(mbean, taskMethod, [templateName, templateValidFrom, templateNamespace] )
            #endFor
            print "Changing template '%s' state to '%s' in Websphere configuration" % (template, state)
            AdminConfig.modify(AdminConfig.showAttribute(template, "stateManagement" ), [["initialState", state]] )
        #endFor
    #endElse

