package com.xebialabs.deployit.plugin.cloud.step.rule;

import java.util.Collection;
import java.util.List;

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.cloud.util.CiFilters;

import static com.google.common.collect.Collections2.filter;
import static java.lang.String.format;

@SuppressWarnings("serial")
public class SingleEnvCheck implements ResultCheck {

    @Override
    public void check(final List<? extends ConfigurationItem> cis) throws Failed {
        Collection<? extends ConfigurationItem> cloudEnvs = filter(cis, CiFilters.CloudEnvironments);

        if (cloudEnvs.size() != 1) {
            String errorPattern =  "There should be exactly one CI of type %s.%s, %s found.";
            throw new Failed(format(errorPattern, CiFilters.cloudEnvType.getPrefix(), CiFilters.cloudEnvType.getName(), cloudEnvs.size()));
        }

    }
}
