/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.cloud.step;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.cloud.ci.BaseHostTemplate;
import com.xebialabs.deployit.plugin.cloud.step.ContextAttribute;
import com.xebialabs.deployit.plugin.cloud.util.CiParser;
import com.xebialabs.deployit.plugin.cloud.util.ContextHelper;
import com.xebialabs.deployit.plugin.cloud.util.InstanceDescriptorResolver;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class RegisterInstancesStep
implements Step {
    public static final String HOSTS_MAP_CTX_ATTRIBUTE = "hosts";
    private final String hostsPath;
    private InstanceDescriptorResolver descriptorResolver;
    private CiParser ciParser;

    public RegisterInstancesStep(InstanceDescriptorResolver descriptorResolver, CiParser ciParser, String hostsPath) {
        this.descriptorResolver = descriptorResolver;
        this.ciParser = ciParser;
        this.hostsPath = hostsPath;
    }

    public int getOrder() {
        return 80;
    }

    public String getDescription() {
        return "Register created instances in repository";
    }

    public StepExitCode execute(ExecutionContext ctx) throws Exception {
        List templates;
        List instances;
        try {
            instances = (List)Preconditions.checkNotNull((Object)((List)ctx.getAttribute(ContextAttribute.CREATED_INSTANCES.name())));
            templates = (List)Preconditions.checkNotNull((Object)((List)ctx.getAttribute(ContextAttribute.USED_TEMPLATES.name())));
        }
        catch (NullPointerException e) {
            ctx.logError("Can not find required context attribute", (Throwable)e);
            return StepExitCode.FAIL;
        }
        for (int i = 0; i < instances.size(); ++i) {
            BaseHostTemplate instanceTpl = (BaseHostTemplate)((Object)templates.get(i));
            String cloudId = (String)instances.get(i);
            String instancePublicAddress = instanceTpl.getInstanceIpAddress(cloudId);
            HashMap scope = Maps.newHashMap();
            scope.put("hostsPath", this.hostsPath);
            scope.put("hostTemplate", instanceTpl);
            scope.put("cloudId", cloudId);
            scope.put("hostAddress", instancePublicAddress);
            String descriptor = this.descriptorResolver.resolve(instanceTpl.getXmlDescriptor(), scope);
            List<ConfigurationItem> cis = this.ciParser.fromString(descriptor, ctx.getRepository());
            for (ConfigurationItem ci : cis) {
                ctx.logOutput("Configuration item " + ci.getId() + " has been created");
            }
            ctx.getRepository().create(cis.toArray(new ConfigurationItem[cis.size()]));
            ctx.logOutput("Host " + instancePublicAddress + " with underlying middleware is created");
            Collection hosts = Collections2.filter(cis, (Predicate)new Predicate<ConfigurationItem>(){

                public boolean apply(ConfigurationItem ci) {
                    return ci.getType().getDescriptor().isAssignableTo(Type.valueOf((String)"overthere.Host"));
                }
            });
            ContextHelper.wrapped(ctx).safeSet(HOSTS_MAP_CTX_ATTRIBUTE, new HashSet(), hosts);
        }
        return StepExitCode.SUCCESS;
    }
}

