package com.xebialabs.deployit.plugin.cloud.task;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Delegate;
import com.xebialabs.deployit.plugin.cloud.ci.InstantiatableCloudTemplate;
import com.xebialabs.deployit.plugin.cloud.step.UnregisterInstanceStep;

import static com.google.common.collect.Lists.newArrayList;

public class CloudHostDelegates {

    @Delegate(name="destroyHost")
    public static List<? extends Step> destroy(ConfigurationItem ci, String method, Map<String, String> params) {

        InstantiatableCloudTemplate template = ci.getProperty("template");

        ArrayList<Step> steps = newArrayList(template.produceDestroySteps(ci));
        steps.add(new UnregisterInstanceStep(ci.getId()));
        return steps;
    }

}
