package com.xebialabs.deployit.plugin.cloud.util;

import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.cloud.ci.BaseHostTemplate;
import com.xebialabs.deployit.plugin.overthere.Host;
import com.xebialabs.overthere.OperatingSystemFamily;

import static com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry.getDescriptor;

public class HostFactory {

    public static Host fromTemplate(BaseHostTemplate template) {

        String hostType = OperatingSystemFamily.WINDOWS.equals(template.getOs()) ? "cloud.CifsHost" : "cloud.SshHost";
        Host host = getDescriptor(hostType).newInstance("dummyHostForConnection");

        for (PropertyDescriptor property : template.getType().getDescriptor().getPropertyDescriptors()) {
            if (host.hasProperty(property.getName()) && !property.getName().equals("connectionType")) {
                host.setProperty(property.getName(), template.getProperty(property.getName()));
            }
        }

        // Enum conversion happens
        host.setProperty("connectionType", template.getConnectionType().name());
        host.setProperty("template", template);
        return host;
    }
}

