/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xldeploy.authentication.oidc.conf;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import com.xebialabs.deployit.ServerConfiguration;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.springframework.security.oauth2.jose.jws.SignatureAlgorithm;
import org.springframework.web.util.UriComponentsBuilder;
import scala.Predef$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005-f\u0001B\u001e=\u0001%C\u0001\u0002\u0015\u0001\u0003\u0002\u0003\u0006I!\u0015\u0005\t1\u0002\u0011\t\u0011)A\u00053\")q\f\u0001C\u0001A\"9Q\r\u0001b\u0001\n\u00031\u0007B\u0002:\u0001A\u0003%q\rC\u0004t\u0001\t\u0007I\u0011\u00014\t\rQ\u0004\u0001\u0015!\u0003h\u0011\u001d)\bA1A\u0005\u0002\u0019DaA\u001e\u0001!\u0002\u00139\u0007bB<\u0001\u0005\u0004%\tA\u001a\u0005\u0007q\u0002\u0001\u000b\u0011B4\t\u000fe\u0004!\u0019!C\u0001M\"1!\u0010\u0001Q\u0001\n\u001dDqa\u001f\u0001C\u0002\u0013\u0005a\r\u0003\u0004}\u0001\u0001\u0006Ia\u001a\u0005\b{\u0002\u0011\r\u0011\"\u0001g\u0011\u0019q\b\u0001)A\u0005O\"9q\u0010\u0001b\u0001\n\u00031\u0007bBA\u0001\u0001\u0001\u0006Ia\u001a\u0005\t\u0003\u0007\u0001!\u0019!C\u0001M\"9\u0011Q\u0001\u0001!\u0002\u00139\u0007\u0002CA\u0004\u0001\t\u0007I\u0011\u00014\t\u000f\u0005%\u0001\u0001)A\u0005O\"A\u00111\u0002\u0001C\u0002\u0013\u0005a\rC\u0004\u0002\u000e\u0001\u0001\u000b\u0011B4\t\u0011\u0005=\u0001A1A\u0005\u0002\u0019Dq!!\u0005\u0001A\u0003%q\r\u0003\u0005\u0002\u0014\u0001\u0011\r\u0011\"\u0001g\u0011\u001d\t)\u0002\u0001Q\u0001\n\u001dD\u0001\"a\u0006\u0001\u0005\u0004%\tA\u001a\u0005\b\u00033\u0001\u0001\u0015!\u0003h\u0011!\tY\u0002\u0001b\u0001\n\u00031\u0007bBA\u000f\u0001\u0001\u0006Ia\u001a\u0005\t\u0003?\u0001!\u0019!C\u0001M\"9\u0011\u0011\u0005\u0001!\u0002\u00139\u0007\u0002CA\u0012\u0001\t\u0007I\u0011\u00014\t\u000f\u0005\u0015\u0002\u0001)A\u0005O\"A\u0011q\u0005\u0001C\u0002\u0013\u0005a\rC\u0004\u0002*\u0001\u0001\u000b\u0011B4\t\u0011\u0005-\u0002A1A\u0005\u0002\u0019Dq!!\f\u0001A\u0003%q\r\u0003\u0005\u00020\u0001\u0011\r\u0011\"\u0001g\u0011\u001d\t\t\u0004\u0001Q\u0001\n\u001dD\u0001\"a\r\u0001\u0005\u0004%\tA\u001a\u0005\b\u0003k\u0001\u0001\u0015!\u0003h\u0011!\t9\u0004\u0001b\u0001\n\u00031\u0007bBA\u001d\u0001\u0001\u0006Ia\u001a\u0005\n\u0003w\u0001\u0001\u0019!C\u0001\u0003{A\u0011\"a\u0014\u0001\u0001\u0004%\t!!\u0015\t\u0011\u0005u\u0003\u0001)Q\u0005\u0003\u007fA\u0011\"a\u0018\u0001\u0001\u0004%\t!!\u0019\t\u0013\u0005=\u0004\u00011A\u0005\u0002\u0005E\u0004\u0002CA;\u0001\u0001\u0006K!a\u0019\t\u000f\u0005]\u0004\u0001\"\u0003\u0002z!9\u0011Q\u0011\u0001\u0005\n\u0005\u001d\u0005bBAH\u0001\u0011%\u0011\u0011\u0013\u0005\b\u0003/\u0003A\u0011BAM\u0011\u001d\t\t\u000b\u0001C\u0005\u0003G\u0013!bT5eG\u000e{gNZ5h\u0015\tid(\u0001\u0003d_:4'BA A\u0003\u0011y\u0017\u000eZ2\u000b\u0005\u0005\u0013\u0015AD1vi\",g\u000e^5dCRLwN\u001c\u0006\u0003\u0007\u0012\u000b\u0001\u0002\u001f7eKBdw.\u001f\u0006\u0003\u000b\u001a\u000b\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003\u001d\u000b1aY8n\u0007\u0001\u0019\"\u0001\u0001&\u0011\u0005-sU\"\u0001'\u000b\u00035\u000bQa]2bY\u0006L!a\u0014'\u0003\r\u0005s\u0017PU3g\u0003\u0019\u0019wN\u001c4jOB\u0011!KV\u0007\u0002'*\u0011\u0001\u000b\u0016\u0006\u0003+\u001a\u000b\u0001\u0002^=qKN\fg-Z\u0005\u0003/N\u0013aaQ8oM&<\u0017aE:feZ,'oQ8oM&<WO]1uS>t\u0007C\u0001.^\u001b\u0005Y&B\u0001/E\u0003!!W\r\u001d7ps&$\u0018B\u00010\\\u0005M\u0019VM\u001d<fe\u000e{gNZ5hkJ\fG/[8o\u0003\u0019a\u0014N\\5u}Q\u0019\u0011m\u00193\u0011\u0005\t\u0004Q\"\u0001\u001f\t\u000bA\u001b\u0001\u0019A)\t\u000ba\u001b\u0001\u0019A-\u0002\u001dI,w-[:ue\u0006$\u0018n\u001c8JIV\tq\r\u0005\u0002i_:\u0011\u0011.\u001c\t\u0003U2k\u0011a\u001b\u0006\u0003Y\"\u000ba\u0001\u0010:p_Rt\u0014B\u00018M\u0003\u0019\u0001&/\u001a3fM&\u0011\u0001/\u001d\u0002\u0007'R\u0014\u0018N\\4\u000b\u00059d\u0015a\u0004:fO&\u001cHO]1uS>t\u0017\n\u001a\u0011\u0002\u0011\rd\u0017.\u001a8u\u0013\u0012\f\u0011b\u00197jK:$\u0018\n\u001a\u0011\u0002\u0019\rd\u0017.\u001a8u'\u0016\u001c'/\u001a;\u0002\u001b\rd\u0017.\u001a8u'\u0016\u001c'/\u001a;!\u0003A\u0019G.[3oi\u0006+H\u000f['fi\"|G-A\tdY&,g\u000e^!vi\"lU\r\u001e5pI\u0002\na![:tk\u0016\u0014\u0018aB5tgV,'\u000fI\u0001\tU^\\7oX;sS\u0006I!n^6t?V\u0014\u0018\u000eI\u0001\u000fC\u000e\u001cWm]:U_.,g.\u0016:j\u0003=\t7mY3tgR{7.\u001a8Ve&\u0004\u0013\u0001F;tKJ\fU\u000f\u001e5pe&T\u0018\r^5p]V\u0013\u0018.A\u000bvg\u0016\u0014\u0018)\u001e;i_JL'0\u0019;j_:,&/\u001b\u0011\u0002\u00131|wm\\;u+JL\u0017A\u00037pO>,H/\u0016:jA\u0005Y!/\u001a3je\u0016\u001cG/\u0016:j\u00031\u0011X\rZ5sK\u000e$XK]5!\u0003U\u0001xn\u001d;M_\u001e|W\u000f\u001e*fI&\u0014Xm\u0019;Ve&\fa\u0003]8ti2{wm\\;u%\u0016$\u0017N]3diV\u0013\u0018\u000eI\u0001\u000fe>dWm]\"mC&lg*Y7f\u0003=\u0011x\u000e\\3t\u00072\f\u0017.\u001c(b[\u0016\u0004\u0013!E;tKJt\u0015-\\3DY\u0006LWNT1nK\u0006\u0011Ro]3s\u001d\u0006lWm\u00117bS6t\u0015-\\3!\u00035IG\rV8lK:TukU!mO\u0006q\u0011\u000e\u001a+pW\u0016t'jV*BY\u001e\u0004\u0013!E1dG\u0016\u001c8\u000fV8lK:L5o];fe\u0006\u0011\u0012mY2fgN$vn[3o\u0013N\u001cX/\u001a:!\u0003M\t7mY3tgR{7.\u001a8Bk\u0012LWM\\2f\u0003Q\t7mY3tgR{7.\u001a8Bk\u0012LWM\\2fA\u0005\t\u0012mY2fgN$vn[3o\u0017\u0016LXK]5\u0002%\u0005\u001c7-Z:t)>\\WM\\&fsV\u0013\u0018\u000eI\u0001\u0012C\u000e\u001cWm]:U_.,gNS,T\u00032<\u0017AE1dG\u0016\u001c8\u000fV8lK:TukU!mO\u0002\nA#Y2dKN\u001cHk\\6f]N+7M]3u\u0017\u0016L\u0018!F1dG\u0016\u001c8\u000fV8lK:\u001cVm\u0019:fi.+\u0017\u0010I\u0001\u000fKb$XM\u001d8bY~cwnZ5o\u0003=)\u0007\u0010^3s]\u0006dw\f\\8hS:\u0004\u0013A\u00067pO&tW*\u001a;i_\u0012$Um]2sSB$\u0018n\u001c8\u0002/1|w-\u001b8NKRDw\u000e\u001a#fg\u000e\u0014\u0018\u000e\u001d;j_:\u0004\u0013!\u00039s_bL\bj\\:u\u0003)\u0001(o\u001c=z\u0011>\u001cH\u000fI\u0001\naJ|\u00070\u001f)peR,\"!a\u0010\u0011\t\u0005\u0005\u00131J\u0007\u0003\u0003\u0007RA!!\u0012\u0002H\u0005!A.\u00198h\u0015\t\tI%\u0001\u0003kCZ\f\u0017\u0002BA'\u0003\u0007\u0012q!\u00138uK\u001e,'/A\u0007qe>D\u0018\u0010U8si~#S-\u001d\u000b\u0005\u0003'\nI\u0006E\u0002L\u0003+J1!a\u0016M\u0005\u0011)f.\u001b;\t\u0013\u0005m\u0013'!AA\u0002\u0005}\u0012a\u0001=%c\u0005Q\u0001O]8ysB{'\u000f\u001e\u0011\u0002\rM\u001cw\u000e]3t+\t\t\u0019\u0007E\u0003\u0002f\u0005-t-\u0004\u0002\u0002h)!\u0011\u0011NA$\u0003\u0011)H/\u001b7\n\t\u00055\u0014q\r\u0002\u0005\u0019&\u001cH/\u0001\u0006tG>\u0004Xm]0%KF$B!a\u0015\u0002t!I\u00111\f\u001b\u0002\u0002\u0003\u0007\u00111M\u0001\bg\u000e|\u0007/Z:!\u0003E9W\r^*ue&tw\r\u0015:pa\u0016\u0014H/\u001f\u000b\bO\u0006m\u0014QPAA\u0011\u0015\u0001f\u00071\u0001R\u0011\u0019\tyH\u000ea\u0001O\u0006!a.Y7f\u0011\u0019\t\u0019I\u000ea\u0001O\u0006aA-\u001a4bk2$h+\u00197vK\u0006qq-\u001a;J]R\u0004&o\u001c9feRLH\u0003CA \u0003\u0013\u000bY)!$\t\u000bA;\u0004\u0019A)\t\r\u0005}t\u00071\u0001h\u0011\u001d\t\u0019i\u000ea\u0001\u0003\u007f\t1cZ3u\u000b:\u001cw\u000eZ3e+JL7\u000b\u001e:j]\u001e$2aZAJ\u0011\u0019\t)\n\u000fa\u0001O\u0006\u0019QO]5\u0002'\u001d,G\u000fR3d_\u0012,G-\u0016:j'R\u0014\u0018N\\4\u0015\t\u0005m\u0015q\u0014\t\u0005\u0003\u0003\ni*C\u0002q\u0003\u0007Ba!!&:\u0001\u00049\u0017!F4fiN#(/\u001b8h\u0019&\u001cH\u000f\u0015:pa\u0016\u0014H/\u001f\u000b\t\u0003G\n)+a*\u0002*\")\u0001K\u000fa\u0001#\"1\u0011q\u0010\u001eA\u0002\u001dDq!a!;\u0001\u0004\t\u0019\u0007")
public class OidcConfig {
    private final String registrationId;
    private final String clientId;
    private final String clientSecret;
    private final String clientAuthMethod;
    private final String issuer;
    private final String jwks_uri;
    private final String accessTokenUri;
    private final String userAuthorizationUri;
    private final String logoutUri;
    private final String redirectUri;
    private final String postLogoutRedirectUri;
    private final String rolesClaimName;
    private final String userNameClaimName;
    private final String idTokenJWSAlg;
    private final String accessTokenIssuer;
    private final String accessTokenAudience;
    private final String accessTokenKeyUri;
    private final String accessTokenJWSAlg;
    private final String accessTokenSecretKey;
    private final String external_login;
    private final String loginMethodDescription;
    private final String proxyHost;
    private Integer proxyPort;
    private List<String> scopes;

    public String registrationId() {
        return this.registrationId;
    }

    public String clientId() {
        return this.clientId;
    }

    public String clientSecret() {
        return this.clientSecret;
    }

    public String clientAuthMethod() {
        return this.clientAuthMethod;
    }

    public String issuer() {
        return this.issuer;
    }

    public String jwks_uri() {
        return this.jwks_uri;
    }

    public String accessTokenUri() {
        return this.accessTokenUri;
    }

    public String userAuthorizationUri() {
        return this.userAuthorizationUri;
    }

    public String logoutUri() {
        return this.logoutUri;
    }

    public String redirectUri() {
        return this.redirectUri;
    }

    public String postLogoutRedirectUri() {
        return this.postLogoutRedirectUri;
    }

    public String rolesClaimName() {
        return this.rolesClaimName;
    }

    public String userNameClaimName() {
        return this.userNameClaimName;
    }

    public String idTokenJWSAlg() {
        return this.idTokenJWSAlg;
    }

    public String accessTokenIssuer() {
        return this.accessTokenIssuer;
    }

    public String accessTokenAudience() {
        return this.accessTokenAudience;
    }

    public String accessTokenKeyUri() {
        return this.accessTokenKeyUri;
    }

    public String accessTokenJWSAlg() {
        return this.accessTokenJWSAlg;
    }

    public String accessTokenSecretKey() {
        return this.accessTokenSecretKey;
    }

    public String external_login() {
        return this.external_login;
    }

    public String loginMethodDescription() {
        return this.loginMethodDescription;
    }

    public String proxyHost() {
        return this.proxyHost;
    }

    public Integer proxyPort() {
        return this.proxyPort;
    }

    public void proxyPort_$eq(Integer x$1) {
        this.proxyPort = x$1;
    }

    public List<String> scopes() {
        return this.scopes;
    }

    public void scopes_$eq(List<String> x$1) {
        this.scopes = x$1;
    }

    private String getStringProperty(Config config, String name, String defaultValue) {
        String string;
        try {
            string = config.getString(name);
        }
        catch (ConfigException.Missing missing) {
            string = defaultValue;
        }
        return string;
    }

    private Integer getIntProperty(Config config, String name, Integer defaultValue) {
        Integer n;
        try {
            n = Predef$.MODULE$.int2Integer(config.getInt(name));
        }
        catch (ConfigException.Missing missing) {
            n = defaultValue;
        }
        return n;
    }

    private String getEncodedUriString(String uri) {
        String string;
        try {
            string = URI.create(uri).toASCIIString();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            string = UriComponentsBuilder.fromUriString((String)uri).build().toUri().toASCIIString();
        }
        return string;
    }

    private String getDecodedUriString(String uri) {
        String string;
        try {
            string = URLDecoder.decode(uri, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalArgumentException(String.format("Cannot decode value [%s] with 'utf-8' charset", uri));
        }
        return string;
    }

    private List<String> getStringListProperty(Config config, String name, List<String> defaultValue) {
        List<String> list;
        try {
            list = config.getStringList(name);
        }
        catch (ConfigException.Missing missing) {
            list = defaultValue;
        }
        return list;
    }

    public OidcConfig(Config config, ServerConfiguration serverConfiguration) {
        this.registrationId = "xl-deploy";
        this.clientId = config.getString("deploy.security.auth.providers.oidc.clientId");
        this.clientSecret = this.getStringProperty(config, "deploy.security.auth.providers.oidc.clientSecret", "");
        this.clientAuthMethod = this.getStringProperty(config, "deploy.security.auth.providers.oidc.clientAuthMethod", "client_secret_post");
        this.issuer = this.getDecodedUriString(config.getString("deploy.security.auth.providers.oidc.issuer"));
        this.jwks_uri = this.getEncodedUriString(this.getStringProperty(config, "deploy.security.auth.providers.oidc.keyRetrievalUri", ""));
        this.accessTokenUri = this.getDecodedUriString(this.getStringProperty(config, "deploy.security.auth.providers.oidc.accessTokenUri", ""));
        this.userAuthorizationUri = this.getEncodedUriString(this.getStringProperty(config, "deploy.security.auth.providers.oidc.userAuthorizationUri", ""));
        this.logoutUri = this.getDecodedUriString(this.getStringProperty(config, "deploy.security.auth.providers.oidc.logoutUri", ""));
        this.redirectUri = this.getEncodedUriString(this.getStringProperty(config, "deploy.security.auth.providers.oidc.redirectUri", new StringBuilder(20).append(serverConfiguration.getServerUrl()).append("login/external-login").toString()));
        this.postLogoutRedirectUri = this.getStringProperty(config, "deploy.security.auth.providers.oidc.postLogoutRedirectUri", this.redirectUri());
        this.rolesClaimName = config.getString("deploy.security.auth.providers.oidc.rolesClaimName");
        this.userNameClaimName = config.getString("deploy.security.auth.providers.oidc.userNameClaimName");
        this.idTokenJWSAlg = this.getStringProperty(config, "deploy.security.auth.providers.oidc.idTokenJWSAlg", SignatureAlgorithm.RS256.getName());
        this.accessTokenIssuer = this.getStringProperty(config, "deploy.security.auth.providers.oidc.access-token.issuer", "");
        this.accessTokenAudience = this.getStringProperty(config, "deploy.security.auth.providers.oidc.access-token.audience", "");
        this.accessTokenKeyUri = this.getStringProperty(config, "deploy.security.auth.providers.oidc.access-token.keyRetrievalUri", "");
        this.accessTokenJWSAlg = this.getStringProperty(config, "deploy.security.auth.providers.oidc.access-token.jwsAlg", SignatureAlgorithm.RS256.getName());
        this.accessTokenSecretKey = this.getStringProperty(config, "deploy.security.auth.providers.oidc.access-token.secretKey", "");
        this.external_login = new StringBuilder(22).append("/oauth2/authorization").append("/").append(this.registrationId()).toString();
        this.loginMethodDescription = this.getStringProperty(config, "deploy.security.auth.providers.oidc.loginMethodDescription", "External login (OpenID Connect)");
        this.proxyHost = this.getStringProperty(config, "deploy.security.auth.providers.oidc.proxyHost", null);
        this.proxyPort = this.getIntProperty(config, "deploy.security.auth.providers.oidc.proxyPort", null);
        this.scopes = this.getStringListProperty(config, "deploy.security.auth.providers.oidc.scopes", (List<String>)new ArrayList<String>(null){
            {
                this.add("openid");
            }
        });
    }
}

