/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xldeploy.auth.oidc.config;

import com.xebialabs.deployit.core.api.dto.LoginProvider;
import com.xebialabs.deployit.spring.HoconPropertySourceFactory;
import com.xebialabs.platform.sso.crypto.KeyRetriever;
import com.xebialabs.platform.sso.oidc.policy.ClaimsToGrantedAuthoritiesPolicy;
import com.xebialabs.platform.sso.oidc.policy.ClaimsToUserNamePolicy;
import com.xebialabs.platform.sso.oidc.policy.impl.DefaultClaimsToGrantedAuthoritiesPolicy;
import com.xebialabs.platform.sso.oidc.policy.impl.DefaultClaimsToUserPolicy;
import com.xebialabs.platform.sso.oidc.userdetails.OpenIdConnectUserDetails;
import com.xebialabs.platform.sso.oidc.web.OpenIdConnectFilter;
import com.xebialabs.platform.sso.oidc.web.OpenIdLogoutSuccessHandler;
import com.xebialabs.xldeploy.auth.oidc.web.XlDeployLoginFormFilter;
import com.xebialabs.xldeploy.authentication.oidc.conf.PeriodicKeyRetrieval;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.client.OAuth2ClientContext;
import org.springframework.security.oauth2.client.OAuth2RestTemplate;
import org.springframework.security.oauth2.client.resource.OAuth2ProtectedResourceDetails;
import org.springframework.security.oauth2.client.token.grant.code.AuthorizationCodeResourceDetails;
import org.springframework.security.oauth2.common.AuthenticationScheme;
import org.springframework.security.oauth2.config.annotation.web.configuration.EnableOAuth2Client;
import org.springframework.security.web.authentication.LoginUrlAuthenticationEntryPoint;
import org.springframework.security.web.authentication.session.SessionAuthenticationStrategy;

@Configuration
@EnableOAuth2Client
@PropertySource(factory=HoconPropertySourceFactory.class, value={"classpath:auth-oidc.conf"})
public class OpenIdConnectConfig {
    @Value(value="${xl.security.auth.providers.oidc.endpoint:/login/external-login}")
    private String external_login;
    @Value(value="${xl.security.auth.providers.oidc.clientId}")
    private String clientId;
    @Value(value="${xl.security.auth.providers.oidc.issuer}")
    private String issuer;
    @Value(value="${xl.security.auth.providers.oidc.clientSecret}")
    private String clientSecret;
    @Value(value="${xl.security.auth.providers.oidc.keyRetrievalUri}")
    private String jwks_uri;
    @Value(value="${xl.security.auth.providers.oidc.keyRetrievalSchedule:3 21 0 * * *}")
    private String keyRetrieveSchedule;
    @Value(value="${xl.security.auth.providers.oidc.accessTokenUri}")
    private String accessTokenUri;
    @Value(value="${xl.security.auth.providers.oidc.userAuthorizationUri}")
    private String userAuthorizationUri;
    @Value(value="${xl.security.auth.providers.oidc.redirectUri}")
    private String redirectUri;
    @Value(value="${xl.security.auth.providers.oidc.logoutUri}")
    private String logoutUri;
    @Value(value="${xl.security.auth.providers.oidc.rolesClaimName}")
    private String rolesClaimName;
    @Value(value="${xl.security.auth.providers.oidc.userNameClaimName}")
    private String userNameClaimName;
    @Value(value="${xl.security.auth.providers.oidc.loginMethodDescription:External login (OpenID Connect)}")
    private String loginMethodDescription;

    @Bean
    public LoginProvider oidcLoginProvider() {
        return new LoginProvider(this.loginMethodDescription, "." + this.external_login, "./logout", false);
    }

    @Bean
    public LoginProvider localLoginProvider() {
        return new LoginProvider("XL Deploy local login", "./login", "./logout", true);
    }

    @Bean
    @Autowired
    public OpenIdConnectFilter openIdConnectFilter(AuthenticationManager authenticationManager, OAuth2ClientContext oAuth2ClientContext, ClaimsToUserNamePolicy claimsToUserNamePolicy, ClaimsToGrantedAuthoritiesPolicy claimsToGrantedAuthoritiesPolicy) {
        KeyRetriever keyRetriever = new KeyRetriever(this.jwks_uri);
        PeriodicKeyRetrieval.setup(keyRetriever, this.keyRetrieveSchedule);
        OpenIdConnectFilter filter = new OpenIdConnectFilter(this.external_login, this.clientId, this.issuer, this.openIdTemplate(oAuth2ClientContext), keyRetriever, claimsToUserNamePolicy, claimsToGrantedAuthoritiesPolicy);
        filter.setAuthenticationManager(authenticationManager);
        return filter;
    }

    @Bean
    public OAuth2ProtectedResourceDetails openIdDetails() {
        AuthorizationCodeResourceDetails details = new AuthorizationCodeResourceDetails();
        details.setClientId(this.clientId);
        details.setClientSecret(this.clientSecret);
        details.setAccessTokenUri(this.accessTokenUri);
        details.setUserAuthorizationUri(this.userAuthorizationUri);
        details.setScope(Collections.singletonList("openid"));
        details.setPreEstablishedRedirectUri(this.redirectUri);
        details.setUseCurrentUri(false);
        details.setClientAuthenticationScheme(AuthenticationScheme.form);
        return details;
    }

    @Bean
    public ClaimsToUserNamePolicy claimsToUserNamePolicy() {
        return new DefaultClaimsToUserPolicy(this.userNameClaimName);
    }

    @Bean
    public ClaimsToGrantedAuthoritiesPolicy claimsToGrantedAuthoritiesPolicy() {
        return new DefaultClaimsToGrantedAuthoritiesPolicy(this.rolesClaimName);
    }

    @Bean
    public OpenIdLogoutSuccessHandler openIdLogoutSuccessHandler() {
        return new OpenIdLogoutSuccessHandler(this.logoutUri){

            public void onLogoutSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException, ServletException {
                super.onLogoutSuccess(request, response, authentication);
                if (authentication == null || !(authentication.getDetails() instanceof OpenIdConnectUserDetails)) {
                    response.sendRedirect(request.getContextPath() + OpenIdConnectConfig.this.loginUrlAuthenticationEntryPoint().getLoginFormUrl());
                }
            }
        };
    }

    @Bean
    @Autowired
    public XlDeployLoginFormFilter defaultLoginFormFilter(AuthenticationManager authenticationManager, SessionAuthenticationStrategy sessionAuthenticationStrategy) {
        XlDeployLoginFormFilter filter = new XlDeployLoginFormFilter(this.defaultOidcMustacheTemplateSettings());
        filter.setAuthenticationManager(authenticationManager);
        filter.setSessionAuthenticationStrategy(sessionAuthenticationStrategy);
        return filter;
    }

    @Bean
    public LoginUrlAuthenticationEntryPoint loginUrlAuthenticationEntryPoint() {
        return new LoginUrlAuthenticationEntryPoint(this.external_login);
    }

    @Bean
    public OAuth2RestTemplate openIdTemplate(OAuth2ClientContext clientContext) {
        return new OAuth2RestTemplate(this.openIdDetails(), clientContext);
    }

    public Map<String, String> defaultOidcMustacheTemplateSettings() {
        HashMap<String, String> scope = new HashMap<String, String>();
        scope.put("productLogo", "./images/xl-deploy-logo.svg");
        scope.put("productColor", "#0099cc");
        scope.put("productIcon", "./favicon.ico");
        scope.put("productName", "XL Deploy");
        return scope;
    }
}

