/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xldeploy.authentication.oidc.conf;

import com.typesafe.config.ConfigFactory;
import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.core.api.dto.LoginProvider;
import com.xebialabs.deployit.spring.HoconPropertySourceFactory;
import com.xebialabs.platform.sso.crypto.KeyRetriever;
import com.xebialabs.platform.sso.oidc.policy.ClaimsToGrantedAuthoritiesPolicy;
import com.xebialabs.platform.sso.oidc.policy.ClaimsToUserNamePolicy;
import com.xebialabs.platform.sso.oidc.policy.impl.DefaultClaimsToGrantedAuthoritiesPolicy;
import com.xebialabs.platform.sso.oidc.policy.impl.DefaultClaimsToUserPolicy;
import com.xebialabs.platform.sso.oidc.userdetails.OpenIdConnectUserDetails;
import com.xebialabs.platform.sso.oidc.web.OpenIdConnectFilter;
import com.xebialabs.platform.sso.oidc.web.OpenIdLogoutSuccessHandler;
import com.xebialabs.xldeploy.auth.oidc.web.XlDeployLoginFormFilter;
import com.xebialabs.xldeploy.authentication.oidc.conf.OidcConfig;
import com.xebialabs.xldeploy.authentication.oidc.conf.PeriodicKeyRetrieval$;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.client.OAuth2ClientContext;
import org.springframework.security.oauth2.client.OAuth2RestTemplate;
import org.springframework.security.oauth2.client.resource.OAuth2ProtectedResourceDetails;
import org.springframework.security.oauth2.client.token.AccessTokenProvider;
import org.springframework.security.oauth2.client.token.AccessTokenProviderChain;
import org.springframework.security.oauth2.client.token.grant.code.AuthorizationCodeAccessTokenProvider;
import org.springframework.security.oauth2.client.token.grant.code.AuthorizationCodeResourceDetails;
import org.springframework.security.oauth2.client.token.grant.implicit.ImplicitAccessTokenProvider;
import org.springframework.security.oauth2.common.AuthenticationScheme;
import org.springframework.security.oauth2.config.annotation.web.configuration.EnableOAuth2Client;
import org.springframework.security.web.authentication.LoginUrlAuthenticationEntryPoint;
import org.springframework.security.web.authentication.session.SessionAuthenticationStrategy;
import scala.Predef$;
import scala.reflect.ScalaSignature;

@Configuration
@EnableOAuth2Client
@PropertySource(factory=HoconPropertySourceFactory.class, value={"conf/xl-deploy.conf"})
@ScalaSignature(bytes="\u0006\u0001\u0005uh\u0001B\u0001\u0003\u0001=\u00111c\u00149f]&#7i\u001c8oK\u000e$8i\u001c8gS\u001eT!a\u0001\u0003\u0002\t\r|gN\u001a\u0006\u0003\u000b\u0019\tAa\\5eG*\u0011q\u0001C\u0001\u000fCV$\b.\u001a8uS\u000e\fG/[8o\u0015\tI!\"\u0001\u0005yY\u0012,\u0007\u000f\\8z\u0015\tYA\"A\u0005yK\nL\u0017\r\\1cg*\tQ\"A\u0002d_6\u001c\u0001a\u0005\u0002\u0001!A\u0011\u0011\u0003F\u0007\u0002%)\t1#A\u0003tG\u0006d\u0017-\u0003\u0002\u0016%\t1\u0011I\\=SK\u001aDQa\u0006\u0001\u0005\u0002a\ta\u0001P5oSRtD#A\r\u0011\u0005i\u0001Q\"\u0001\u0002\t\u000bq\u0001A\u0011A\u000f\u0002\u0015=LGmY\"p]\u001aLw-F\u0001\u001f!\tQr$\u0003\u0002!\u0005\tQq*\u001b3d\u0007>tg-[4)\u0005m\u0011\u0003CA\u0012-\u001b\u0005!#BA\u0013'\u0003)\tgN\\8uCRLwN\u001c\u0006\u0003O!\nqaY8oi\u0016DHO\u0003\u0002*U\u0005y1\u000f\u001d:j]\u001e4'/Y7fo>\u00148NC\u0001,\u0003\ry'oZ\u0005\u0003[\u0011\u0012AAQ3b]\")q\u0006\u0001C\u0001a\u0005\tr.\u001b3d\u0019><\u0017N\u001c)s_ZLG-\u001a:\u0016\u0003E\u0002\"AM\u001e\u000e\u0003MR!\u0001N\u001b\u0002\u0007\u0011$xN\u0003\u00027o\u0005\u0019\u0011\r]5\u000b\u0005aJ\u0014\u0001B2pe\u0016T!A\u000f\u0006\u0002\u0011\u0011,\u0007\u000f\\8zSRL!\u0001P\u001a\u0003\u001b1{w-\u001b8Qe>4\u0018\u000eZ3sQ\tq#\u0005C\u0003@\u0001\u0011\u0005\u0001'\u0001\nm_\u000e\fG\u000eT8hS:\u0004&o\u001c<jI\u0016\u0014\bF\u0001 #\u0011\u0015\u0011\u0005\u0001\"\u0001D\u0003My\u0007/\u001a8JI\u000e{gN\\3di\u001aKG\u000e^3s)\u0015!u\n\u00172k!\t)U*D\u0001G\u0015\t9\u0005*A\u0002xK\nT!!B%\u000b\u0005)[\u0015aA:t_*\u0011AJC\u0001\ta2\fGOZ8s[&\u0011aJ\u0012\u0002\u0014\u001fB,g.\u00133D_:tWm\u0019;GS2$XM\u001d\u0005\u0006!\u0006\u0003\r!U\u0001\u0016CV$\b.\u001a8uS\u000e\fG/[8o\u001b\u0006t\u0017mZ3s!\t\u0011f+D\u0001T\u0015\t9AK\u0003\u0002VQ\u0005A1/Z2ve&$\u00180\u0003\u0002X'\n)\u0012)\u001e;iK:$\u0018nY1uS>tW*\u00198bO\u0016\u0014\b\"B-B\u0001\u0004Q\u0016aE8BkRD'g\u00117jK:$8i\u001c8uKb$\bCA.a\u001b\u0005a&BA/_\u0003\u0019\u0019G.[3oi*\u0011q\fV\u0001\u0007_\u0006,H\u000f\u001b\u001a\n\u0005\u0005d&aE(BkRD'g\u00117jK:$8i\u001c8uKb$\b\"B2B\u0001\u0004!\u0017AF2mC&l7\u000fV8Vg\u0016\u0014h*Y7f!>d\u0017nY=\u0011\u0005\u0015DW\"\u00014\u000b\u0005\u001dD\u0015A\u00029pY&\u001c\u00170\u0003\u0002jM\n12\t\\1j[N$v.V:fe:\u000bW.\u001a)pY&\u001c\u0017\u0010C\u0003l\u0003\u0002\u0007A.\u0001\u0011dY\u0006LWn\u001d+p\u000fJ\fg\u000e^3e\u0003V$\bn\u001c:ji&,7\u000fU8mS\u000eL\bCA3n\u0013\tqgM\u0001\u0011DY\u0006LWn\u001d+p\u000fJ\fg\u000e^3e\u0003V$\bn\u001c:ji&,7\u000fU8mS\u000eL\bFA!q!\t\tx/D\u0001s\u0015\t)3O\u0003\u0002uk\u00069a-Y2u_JL(B\u0001<)\u0003\u0015\u0011W-\u00198t\u0013\tA(OA\u0005BkR|w/\u001b:fI\"\u0012\u0011I\t\u0005\u0006w\u0002!\t\u0001`\u0001\u000e_B,g.\u00133EKR\f\u0017\u000e\\:\u0016\u0003u\u00042A`A\u0002\u001b\u0005y(bAA\u00019\u0006A!/Z:pkJ\u001cW-C\u0002\u0002\u0006}\u0014adT!vi\"\u0014\u0004K]8uK\u000e$X\r\u001a*fg>,(oY3EKR\f\u0017\u000e\\:)\u0005i\u0014\u0003BB2\u0001\t\u0003\tY!\u0006\u0002\u0002\u000eA!\u0011qBA\u000b\u001b\t\t\tBC\u0002\u0002\u0014\u0019\fA![7qY&!\u0011qCA\t\u0005e!UMZ1vYR\u001cE.Y5ngR{Wk]3s!>d\u0017nY=)\u0007\u0005%!\u0005\u0003\u0004l\u0001\u0011\u0005\u0011QD\u000b\u0003\u0003?\u0001B!a\u0004\u0002\"%!\u00111EA\t\u0005\u001d\"UMZ1vYR\u001cE.Y5ngR{wI]1oi\u0016$\u0017)\u001e;i_JLG/[3t!>d\u0017nY=)\u0007\u0005m!\u0005C\u0004\u0002*\u0001!\t!a\u000b\u00025=\u0004XM\\%e\u0019><w.\u001e;Tk\u000e\u001cWm]:IC:$G.\u001a:\u0016\u0005\u00055\u0002cA#\u00020%\u0019\u0011\u0011\u0007$\u00035=\u0003XM\\%e\u0019><w.\u001e;Tk\u000e\u001cWm]:IC:$G.\u001a:)\u0007\u0005\u001d\"\u0005C\u0004\u00028\u0001!\t!!\u000f\u0002-\u0011,g-Y;mi2{w-\u001b8G_Jlg)\u001b7uKJ$b!a\u000f\u0002L\u00055\u0003\u0003BA\u001f\u0003\u000fj!!a\u0010\u000b\u0007\u001d\u000b\tEC\u0002\u0006\u0003\u0007R1!!\u0012\t\u0003\u0011\tW\u000f\u001e5\n\t\u0005%\u0013q\b\u0002\u001812$U\r\u001d7ps2{w-\u001b8G_Jlg)\u001b7uKJDa\u0001UA\u001b\u0001\u0004\t\u0006\u0002CA(\u0003k\u0001\r!!\u0015\u0002;M,7o]5p]\u0006+H\u000f[3oi&\u001c\u0017\r^5p]N#(/\u0019;fOf\u0004B!a\u0015\u0002^5\u0011\u0011Q\u000b\u0006\u0005\u0003/\nI&A\u0004tKN\u001c\u0018n\u001c8\u000b\u0007\u001d\tYF\u0003\u0002H)&!\u0011qLA+\u0005u\u0019Vm]:j_:\fU\u000f\u001e5f]RL7-\u0019;j_:\u001cFO]1uK\u001eL\bfAA\u001ba\"\u001a\u0011Q\u0007\u0012\t\u000f\u0005\u001d\u0004\u0001\"\u0001\u0002j\u0005\u0001Cn\\4j]V\u0013H.Q;uQ\u0016tG/[2bi&|g.\u00128uef\u0004v.\u001b8u+\t\tY\u0007\u0005\u0003\u0002n\u0005=TBAA-\u0013\u0011\t\t(!\u0017\u0003A1{w-\u001b8Ve2\fU\u000f\u001e5f]RL7-\u0019;j_:,e\u000e\u001e:z!>Lg\u000e\u001e\u0015\u0004\u0003K\u0012\u0003bBA<\u0001\u0011\u0005\u0011\u0011P\u0001\u000f_B,g.\u00133UK6\u0004H.\u0019;f)\u0011\tY(!!\u0011\u0007m\u000bi(C\u0002\u0002\u0000q\u0013!cT!vi\"\u0014$+Z:u)\u0016l\u0007\u000f\\1uK\"9\u00111QA;\u0001\u0004Q\u0016aE8bkRD'g\u00117jK:$8i\u001c8uKb$\bbBAD\u0001\u0011%\u0011\u0011R\u0001\tg\u0016$\bK]8ysR!\u00111RAI!\r\t\u0012QR\u0005\u0004\u0003\u001f\u0013\"\u0001B+oSRD\u0001\"a%\u0002\u0006\u0002\u0007\u00111P\u0001\u0013_\u0006+H\u000f\u001b\u001aSKN$H+Z7qY\u0006$X\rC\u0004\u0002\u0018\u0002!\t!!'\u0002G\u0011,g-Y;mi>KGmY'vgR\f7\r[3UK6\u0004H.\u0019;f'\u0016$H/\u001b8hgV\u0011\u00111\u0014\t\t\u0003;\u000b9+a+\u0002,6\u0011\u0011q\u0014\u0006\u0005\u0003C\u000b\u0019+\u0001\u0003vi&d'BAAS\u0003\u0011Q\u0017M^1\n\t\u0005%\u0016q\u0014\u0002\u0004\u001b\u0006\u0004\b\u0003BAW\u0003wsA!a,\u00028B\u0019\u0011\u0011\u0017\n\u000e\u0005\u0005M&bAA[\u001d\u00051AH]8pizJ1!!/\u0013\u0003\u0019\u0001&/\u001a3fM&!\u0011QXA`\u0005\u0019\u0019FO]5oO*\u0019\u0011\u0011\u0018\n)\u0015\u0001\t\u0019\r^Ae\u0003/\fI\u000eE\u0002$\u0003\u000bL1!a2%\u00059\u0001&o\u001c9feRL8k\\;sG\u0016\u001c#!a3\u0011\t\u00055\u00171[\u0007\u0003\u0003\u001fT1!!5:\u0003\u0019\u0019\bO]5oO&!\u0011Q[Ah\u0005iAunY8o!J|\u0007/\u001a:usN{WO]2f\r\u0006\u001cGo\u001c:z\u0003\u00151\u0018\r\\;fY\t\tY.\t\u0002\u0002^\u0006\u00192m\u001c8g_adW\u0006Z3qY>LhfY8oM\"\u001a\u0001!!9\u0011\t\u0005\r\u0018\u0011_\u0007\u0003\u0003KTA!a:\u0002j\u0006i1m\u001c8gS\u001e,(/\u0019;j_:T1aRAv\u0015\r)\u0013Q\u001e\u0006\u0004\u0003_t\u0016AB2p]\u001aLw-\u0003\u0003\u0002t\u0006\u0015(AE#oC\ndWmT!vi\"\u00144\t\\5f]RD3\u0001AA|!\r\u0019\u0013\u0011`\u0005\u0004\u0003w$#!D\"p]\u001aLw-\u001e:bi&|g\u000e")
public class OpenIdConnectConfig {
    @Bean
    public OidcConfig oidcConfig() {
        return new OidcConfig(ConfigFactory.load((String)"xl-deploy.conf"));
    }

    @Bean
    public LoginProvider oidcLoginProvider() {
        return new LoginProvider(this.oidcConfig().loginMethodDescription(), "." + this.oidcConfig().external_login(), "./logout", false);
    }

    @Bean
    public LoginProvider localLoginProvider() {
        return new LoginProvider("XL Deploy local login", "./login", "./logout", true);
    }

    @Bean
    @Autowired
    public OpenIdConnectFilter openIdConnectFilter(AuthenticationManager authenticationManager, OAuth2ClientContext oAuth2ClientContext, ClaimsToUserNamePolicy claimsToUserNamePolicy, ClaimsToGrantedAuthoritiesPolicy claimsToGrantedAuthoritiesPolicy) {
        KeyRetriever keyRetriever = new KeyRetriever(this.oidcConfig().jwks_uri());
        if (Strings.isNotEmpty((String)this.oidcConfig().proxyHost())) {
            keyRetriever.setProxy(this.oidcConfig().proxyHost(), this.oidcConfig().proxyPort());
        }
        PeriodicKeyRetrieval$.MODULE$.setup(keyRetriever, this.oidcConfig().keyRetrieveSchedule());
        OpenIdConnectFilter filter = new OpenIdConnectFilter(this.oidcConfig().external_login(), this.oidcConfig().clientId(), this.oidcConfig().issuer(), this.openIdTemplate(oAuth2ClientContext), keyRetriever, claimsToUserNamePolicy, claimsToGrantedAuthoritiesPolicy);
        filter.setAuthenticationManager(authenticationManager);
        return filter;
    }

    /*
     * WARNING - void declaration
     */
    @Bean
    public OAuth2ProtectedResourceDetails openIdDetails() {
        void var1_1;
        AuthorizationCodeResourceDetails details = new AuthorizationCodeResourceDetails();
        details.setClientId(this.oidcConfig().clientId());
        details.setClientSecret(this.oidcConfig().clientSecret());
        details.setAccessTokenUri(this.oidcConfig().accessTokenUri());
        details.setUserAuthorizationUri(this.oidcConfig().userAuthorizationUri());
        details.setScope(Collections.singletonList("openid"));
        details.setPreEstablishedRedirectUri(this.oidcConfig().redirectUri());
        details.setUseCurrentUri(false);
        details.setClientAuthenticationScheme(AuthenticationScheme.form);
        return var1_1;
    }

    @Bean
    public DefaultClaimsToUserPolicy claimsToUserNamePolicy() {
        return new DefaultClaimsToUserPolicy(this.oidcConfig().userNameClaimName());
    }

    @Bean
    public DefaultClaimsToGrantedAuthoritiesPolicy claimsToGrantedAuthoritiesPolicy() {
        return new DefaultClaimsToGrantedAuthoritiesPolicy(this.oidcConfig().rolesClaimName());
    }

    @Bean
    public OpenIdLogoutSuccessHandler openIdLogoutSuccessHandler() {
        return new OpenIdLogoutSuccessHandler(this){
            private final /* synthetic */ OpenIdConnectConfig $outer;

            public void onLogoutSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException, ServletException {
                block0: {
                    super.onLogoutSuccess(request, response, authentication);
                    if (authentication != null && authentication.getDetails() instanceof OpenIdConnectUserDetails) break block0;
                    response.sendRedirect(request.getContextPath() + this.$outer.loginUrlAuthenticationEntryPoint().getLoginFormUrl());
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super($outer.oidcConfig().logoutUri());
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    @Bean
    @Autowired
    public XlDeployLoginFormFilter defaultLoginFormFilter(AuthenticationManager authenticationManager, SessionAuthenticationStrategy sessionAuthenticationStrategy) {
        void var3_3;
        XlDeployLoginFormFilter filter = new XlDeployLoginFormFilter(this.defaultOidcMustacheTemplateSettings());
        filter.setAuthenticationManager(authenticationManager);
        filter.setSessionAuthenticationStrategy(sessionAuthenticationStrategy);
        return var3_3;
    }

    @Bean
    public LoginUrlAuthenticationEntryPoint loginUrlAuthenticationEntryPoint() {
        return new LoginUrlAuthenticationEntryPoint(this.oidcConfig().external_login());
    }

    /*
     * WARNING - void declaration
     */
    public OAuth2RestTemplate openIdTemplate(OAuth2ClientContext oauth2ClientContext) {
        void var2_2;
        block0: {
            OAuth2RestTemplate oAuth2RestTemplate = new OAuth2RestTemplate(this.openIdDetails(), oauth2ClientContext);
            if (!Strings.isNotEmpty((String)this.oidcConfig().proxyHost())) break block0;
            this.setProxy(oAuth2RestTemplate);
        }
        return var2_2;
    }

    private void setProxy(OAuth2RestTemplate oAuth2RestTemplate) {
        SimpleClientHttpRequestFactory requestFactory = new SimpleClientHttpRequestFactory();
        requestFactory.setProxy(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(this.oidcConfig().proxyHost(), Predef$.MODULE$.Integer2int(this.oidcConfig().proxyPort()))));
        AuthorizationCodeAccessTokenProvider authorizationCodeAccessTokenProvider = new AuthorizationCodeAccessTokenProvider();
        authorizationCodeAccessTokenProvider.setRequestFactory((ClientHttpRequestFactory)requestFactory);
        ImplicitAccessTokenProvider implicitAccessTokenProvider = new ImplicitAccessTokenProvider();
        implicitAccessTokenProvider.setRequestFactory((ClientHttpRequestFactory)requestFactory);
        AccessTokenProviderChain accessTokenProvider = new AccessTokenProviderChain(Arrays.asList((Object[])new AccessTokenProvider[]{authorizationCodeAccessTokenProvider, implicitAccessTokenProvider}));
        oAuth2RestTemplate.setAccessTokenProvider((AccessTokenProvider)accessTokenProvider);
    }

    /*
     * WARNING - void declaration
     */
    public Map<String, String> defaultOidcMustacheTemplateSettings() {
        void var1_1;
        HashMap<String, String> scope = new HashMap<String, String>();
        scope.put("productLogo", "./images/xl-deploy-logo.svg");
        scope.put("productColor", "#0099cc");
        scope.put("productIcon", "./favicon.ico");
        scope.put("productName", "XL Deploy");
        return var1_1;
    }
}

