/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xldeploy.authentication.oidc.conf;

import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.core.api.dto.LoginProvider;
import com.xebialabs.deployit.engine.spi.event.LogoutEvent;
import com.xebialabs.deployit.event.EventBusHolder;
import com.xebialabs.deployit.spring.HoconPropertySourceFactory;
import com.xebialabs.platform.sso.crypto.KeyRetriever;
import com.xebialabs.platform.sso.oidc.policy.ClaimsToGrantedAuthoritiesPolicy;
import com.xebialabs.platform.sso.oidc.policy.ClaimsToUserNamePolicy;
import com.xebialabs.platform.sso.oidc.policy.impl.DefaultClaimsToGrantedAuthoritiesPolicy;
import com.xebialabs.platform.sso.oidc.policy.impl.DefaultClaimsToUserPolicy;
import com.xebialabs.platform.sso.oidc.userdetails.OpenIdConnectUserDetails;
import com.xebialabs.platform.sso.oidc.web.OpenIdConnectFilter;
import com.xebialabs.platform.sso.oidc.web.OpenIdLogoutSuccessHandler;
import com.xebialabs.xldeploy.auth.oidc.web.XlDeployLoginFormFilter;
import com.xebialabs.xldeploy.authentication.oidc.conf.OidcConfig;
import com.xebialabs.xldeploy.authentication.oidc.conf.PeriodicKeyRetrieval$;
import com.xebialabs.xlplatform.config.ConfigLoader$;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.client.OAuth2ClientContext;
import org.springframework.security.oauth2.client.OAuth2RestTemplate;
import org.springframework.security.oauth2.client.resource.OAuth2ProtectedResourceDetails;
import org.springframework.security.oauth2.client.token.AccessTokenProvider;
import org.springframework.security.oauth2.client.token.AccessTokenProviderChain;
import org.springframework.security.oauth2.client.token.grant.code.AuthorizationCodeAccessTokenProvider;
import org.springframework.security.oauth2.client.token.grant.code.AuthorizationCodeResourceDetails;
import org.springframework.security.oauth2.client.token.grant.implicit.ImplicitAccessTokenProvider;
import org.springframework.security.oauth2.common.AuthenticationScheme;
import org.springframework.security.oauth2.config.annotation.web.configuration.EnableOAuth2Client;
import org.springframework.security.web.authentication.LoginUrlAuthenticationEntryPoint;
import org.springframework.security.web.authentication.session.SessionAuthenticationStrategy;
import scala.Predef$;
import scala.reflect.ScalaSignature;

@Configuration
@EnableOAuth2Client
@PropertySource(factory=HoconPropertySourceFactory.class, value={"conf/xl-deploy.conf"})
@ScalaSignature(bytes="\u0006\u0001\u0005uh\u0001B\b\u0011\u0001uAQ\u0001\n\u0001\u0005\u0002\u0015BQ\u0001\u000b\u0001\u0005\u0002%BQA\u000f\u0001\u0005\u0002mBQ!\u0013\u0001\u0005\u0002mBQa\u0013\u0001\u0005\u00021Cq!a\u0002\u0001\t\u0003\tI\u0001\u0003\u0004m\u0001\u0011\u0005\u0011\u0011\u0004\u0005\u0007i\u0002!\t!!\u000b\t\u000f\u0005M\u0002\u0001\"\u0001\u00026!9\u0011q\b\u0001\u0005\u0002\u0005\u0005\u0003bBA7\u0001\u0011\u0005\u0011q\u000e\u0005\b\u0003w\u0002A\u0011AA?\u0011\u001d\tI\t\u0001C\u0005\u0003\u0017Cq!a&\u0001\t\u0003\tIJA\nPa\u0016t\u0017\nZ\"p]:,7\r^\"p]\u001aLwM\u0003\u0002\u0012%\u0005!1m\u001c8g\u0015\t\u0019B#\u0001\u0003pS\u0012\u001c'BA\u000b\u0017\u00039\tW\u000f\u001e5f]RL7-\u0019;j_:T!a\u0006\r\u0002\u0011adG-\u001a9m_fT!!\u0007\u000e\u0002\u0013a,'-[1mC\n\u001c(\"A\u000e\u0002\u0007\r|Wn\u0001\u0001\u0014\u0005\u0001q\u0002CA\u0010#\u001b\u0005\u0001#\"A\u0011\u0002\u000bM\u001c\u0017\r\\1\n\u0005\r\u0002#AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002MA\u0011q\u0005A\u0007\u0002!\u0005Qq.\u001b3d\u0007>tg-[4\u0016\u0003)\u0002\"aJ\u0016\n\u00051\u0002\"AC(jI\u000e\u001cuN\u001c4jO\"\u0012!A\f\t\u0003_aj\u0011\u0001\r\u0006\u0003cI\n!\"\u00198o_R\fG/[8o\u0015\t\u0019D'A\u0004d_:$X\r\u001f;\u000b\u0005U2\u0014aD:qe&twM\u001a:b[\u0016<xN]6\u000b\u0003]\n1a\u001c:h\u0013\tI\u0004G\u0001\u0003CK\u0006t\u0017!E8jI\u000edunZ5o!J|g/\u001b3feV\tA\b\u0005\u0002>\r6\taH\u0003\u0002@\u0001\u0006\u0019A\r^8\u000b\u0005\u0005\u0013\u0015aA1qS*\u00111\tR\u0001\u0005G>\u0014XM\u0003\u0002F1\u0005AA-\u001a9m_fLG/\u0003\u0002H}\tiAj\\4j]B\u0013xN^5eKJD#a\u0001\u0018\u0002%1|7-\u00197M_\u001eLg\u000e\u0015:pm&$WM\u001d\u0015\u0003\t9\n1c\u001c9f]&#7i\u001c8oK\u000e$h)\u001b7uKJ$R!\u0014-bWN\u0004\"A\u0014,\u000e\u0003=S!\u0001U)\u0002\u0007],'M\u0003\u0002\u0014%*\u00111\u000bV\u0001\u0004gN|'BA+\u0019\u0003!\u0001H.\u0019;g_Jl\u0017BA,P\u0005My\u0005/\u001a8JI\u000e{gN\\3di\u001aKG\u000e^3s\u0011\u0015IV\u00011\u0001[\u0003U\tW\u000f\u001e5f]RL7-\u0019;j_:l\u0015M\\1hKJ\u0004\"aW0\u000e\u0003qS!!F/\u000b\u0005y#\u0014\u0001C:fGV\u0014\u0018\u000e^=\n\u0005\u0001d&!F!vi\",g\u000e^5dCRLwN\\'b]\u0006<WM\u001d\u0005\u0006E\u0016\u0001\raY\u0001\u0014_\u0006+H\u000f\u001b\u001aDY&,g\u000e^\"p]R,\u0007\u0010\u001e\t\u0003I&l\u0011!\u001a\u0006\u0003M\u001e\faa\u00197jK:$(B\u00015^\u0003\u0019y\u0017-\u001e;ie%\u0011!.\u001a\u0002\u0014\u001f\u0006+H\u000f\u001b\u001aDY&,g\u000e^\"p]R,\u0007\u0010\u001e\u0005\u0006Y\u0016\u0001\r!\\\u0001\u0017G2\f\u0017.\\:U_V\u001bXM\u001d(b[\u0016\u0004v\u000e\\5dsB\u0011a.]\u0007\u0002_*\u0011\u0001/U\u0001\u0007a>d\u0017nY=\n\u0005I|'AF\"mC&l7\u000fV8Vg\u0016\u0014h*Y7f!>d\u0017nY=\t\u000bQ,\u0001\u0019A;\u0002A\rd\u0017-[7t)><%/\u00198uK\u0012\fU\u000f\u001e5pe&$\u0018.Z:Q_2L7-\u001f\t\u0003]ZL!a^8\u0003A\rc\u0017-[7t)><%/\u00198uK\u0012\fU\u000f\u001e5pe&$\u0018.Z:Q_2L7-\u001f\u0015\u0003\u000be\u00042A_A\u0001\u001b\u0005Y(BA\u0019}\u0015\tih0A\u0004gC\u000e$xN]=\u000b\u0005}$\u0014!\u00022fC:\u001c\u0018bAA\u0002w\nI\u0011)\u001e;po&\u0014X\r\u001a\u0015\u0003\u000b9\nQb\u001c9f]&#G)\u001a;bS2\u001cXCAA\u0006!\u0011\ti!a\u0005\u000e\u0005\u0005=!bAA\tK\u0006A!/Z:pkJ\u001cW-\u0003\u0003\u0002\u0016\u0005=!AH(BkRD'\u0007\u0015:pi\u0016\u001cG/\u001a3SKN|WO]2f\t\u0016$\u0018-\u001b7tQ\t1a&\u0006\u0002\u0002\u001cA!\u0011QDA\u0012\u001b\t\tyBC\u0002\u0002\"=\fA![7qY&!\u0011QEA\u0010\u0005e!UMZ1vYR\u001cE.Y5ngR{Wk]3s!>d\u0017nY=)\u0005\u001dqSCAA\u0016!\u0011\ti\"!\f\n\t\u0005=\u0012q\u0004\u0002(\t\u00164\u0017-\u001e7u\u00072\f\u0017.\\:U_\u001e\u0013\u0018M\u001c;fI\u0006+H\u000f[8sSRLWm\u001d)pY&\u001c\u0017\u0010\u000b\u0002\t]\u0005Qr\u000e]3o\u0013\u0012dunZ8viN+8mY3tg\"\u000bg\u000e\u001a7feV\u0011\u0011q\u0007\t\u0004\u001d\u0006e\u0012bAA\u001e\u001f\nQr\n]3o\u0013\u0012dunZ8viN+8mY3tg\"\u000bg\u000e\u001a7fe\"\u0012\u0011BL\u0001\u0017I\u00164\u0017-\u001e7u\u0019><\u0017N\u001c$pe64\u0015\u000e\u001c;feR1\u00111IA*\u0003+\u0002B!!\u0012\u0002P5\u0011\u0011q\t\u0006\u0004!\u0006%#bA\n\u0002L)\u0019\u0011Q\n\f\u0002\t\u0005,H\u000f[\u0005\u0005\u0003#\n9EA\fYY\u0012+\u0007\u000f\\8z\u0019><\u0017N\u001c$pe64\u0015\u000e\u001c;fe\")\u0011L\u0003a\u00015\"9\u0011q\u000b\u0006A\u0002\u0005e\u0013!H:fgNLwN\\!vi\",g\u000e^5dCRLwN\\*ue\u0006$XmZ=\u0011\t\u0005m\u0013QM\u0007\u0003\u0003;RA!a\u0018\u0002b\u000591/Z:tS>t'bA\u000b\u0002d)\u0011\u0001+X\u0005\u0005\u0003O\niFA\u000fTKN\u001c\u0018n\u001c8BkRDWM\u001c;jG\u0006$\u0018n\u001c8TiJ\fG/Z4zQ\tQ\u0011\u0010\u000b\u0002\u000b]\u0005\u0001Cn\\4j]V\u0013H.Q;uQ\u0016tG/[2bi&|g.\u00128uef\u0004v.\u001b8u+\t\t\t\b\u0005\u0003\u0002t\u0005UTBAA1\u0013\u0011\t9(!\u0019\u0003A1{w-\u001b8Ve2\fU\u000f\u001e5f]RL7-\u0019;j_:,e\u000e\u001e:z!>Lg\u000e\u001e\u0015\u0003\u00179\nab\u001c9f]&#G+Z7qY\u0006$X\r\u0006\u0003\u0002\u0000\u0005\u0015\u0005c\u00013\u0002\u0002&\u0019\u00111Q3\u0003%=\u000bU\u000f\u001e53%\u0016\u001cH\u000fV3na2\fG/\u001a\u0005\u0007\u0003\u000fc\u0001\u0019A2\u0002'=\fW\u000f\u001e53\u00072LWM\u001c;D_:$X\r\u001f;\u0002\u0011M,G\u000f\u0015:pqf$B!!$\u0002\u0014B\u0019q$a$\n\u0007\u0005E\u0005E\u0001\u0003V]&$\bbBAK\u001b\u0001\u0007\u0011qP\u0001\u0013_\u0006+H\u000f\u001b\u001aSKN$H+Z7qY\u0006$X-A\u0012eK\u001a\fW\u000f\u001c;PS\u0012\u001cW*^:uC\u000eDW\rV3na2\fG/Z*fiRLgnZ:\u0016\u0005\u0005m\u0005\u0003CAO\u0003O\u000bY+a+\u000e\u0005\u0005}%\u0002BAQ\u0003G\u000bA!\u001e;jY*\u0011\u0011QU\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002*\u0006}%aA'baB!\u0011QVA^\u001d\u0011\ty+a.\u0011\u0007\u0005E\u0006%\u0004\u0002\u00024*\u0019\u0011Q\u0017\u000f\u0002\rq\u0012xn\u001c;?\u0013\r\tI\fI\u0001\u0007!J,G-\u001a4\n\t\u0005u\u0016q\u0018\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005e\u0006\u0005\u000b\u0006\u0001\u0003\u0007l\u0018\u0011ZAl\u00033\u00042aLAc\u0013\r\t9\r\r\u0002\u000f!J|\u0007/\u001a:usN{WO]2fG\t\tY\r\u0005\u0003\u0002N\u0006MWBAAh\u0015\r\t\t\u000eR\u0001\u0007gB\u0014\u0018N\\4\n\t\u0005U\u0017q\u001a\u0002\u001b\u0011>\u001cwN\u001c)s_B,'\u000f^=T_V\u00148-\u001a$bGR|'/_\u0001\u0006m\u0006dW/\u001a\u0017\u0003\u00037\f#!!8\u0002'\r|gNZ\u0018yY6\"W\r\u001d7ps:\u001awN\u001c4)\u0007\u0001\t\t\u000f\u0005\u0003\u0002d\u0006EXBAAs\u0015\u0011\t9/!;\u0002\u001b\r|gNZ5hkJ\fG/[8o\u0015\r\u0001\u00161\u001e\u0006\u0004c\u00055(bAAxO\u000611m\u001c8gS\u001eLA!a=\u0002f\n\u0011RI\\1cY\u0016|\u0015)\u001e;ie\rc\u0017.\u001a8uQ\r\u0001\u0011q\u001f\t\u0004_\u0005e\u0018bAA~a\ti1i\u001c8gS\u001e,(/\u0019;j_:\u0004")
public class OpenIdConnectConfig {
    @Bean
    public OidcConfig oidcConfig() {
        return new OidcConfig(ConfigLoader$.MODULE$.loadWithDynamic("xl-deploy.conf"));
    }

    @Bean
    public LoginProvider oidcLoginProvider() {
        return new LoginProvider(this.oidcConfig().loginMethodDescription(), new StringBuilder(1).append(".").append(this.oidcConfig().external_login()).toString(), "./logout", false);
    }

    @Bean
    public LoginProvider localLoginProvider() {
        return new LoginProvider("XL Deploy local login", "./login", "./logout", true);
    }

    @Bean
    @Autowired
    public OpenIdConnectFilter openIdConnectFilter(AuthenticationManager authenticationManager, OAuth2ClientContext oAuth2ClientContext, ClaimsToUserNamePolicy claimsToUserNamePolicy, ClaimsToGrantedAuthoritiesPolicy claimsToGrantedAuthoritiesPolicy) {
        KeyRetriever keyRetriever = new KeyRetriever(this.oidcConfig().jwks_uri());
        if (Strings.isNotEmpty((String)this.oidcConfig().proxyHost())) {
            keyRetriever.setProxy(this.oidcConfig().proxyHost(), this.oidcConfig().proxyPort());
        }
        PeriodicKeyRetrieval$.MODULE$.setup(keyRetriever, this.oidcConfig().keyRetrieveSchedule());
        OpenIdConnectFilter filter = new OpenIdConnectFilter(this.oidcConfig().external_login(), this.oidcConfig().clientId(), this.oidcConfig().issuer(), this.openIdTemplate(oAuth2ClientContext), keyRetriever, claimsToUserNamePolicy, claimsToGrantedAuthoritiesPolicy);
        filter.setAuthenticationManager(authenticationManager);
        return filter;
    }

    /*
     * WARNING - void declaration
     */
    @Bean
    public OAuth2ProtectedResourceDetails openIdDetails() {
        void var1_1;
        AuthorizationCodeResourceDetails details = new AuthorizationCodeResourceDetails();
        details.setClientId(this.oidcConfig().clientId());
        details.setClientSecret(this.oidcConfig().clientSecret());
        details.setAccessTokenUri(this.oidcConfig().accessTokenUri());
        details.setUserAuthorizationUri(this.oidcConfig().userAuthorizationUri());
        details.setScope(Collections.singletonList("openid"));
        details.setPreEstablishedRedirectUri(this.oidcConfig().redirectUri());
        details.setUseCurrentUri(false);
        details.setClientAuthenticationScheme(AuthenticationScheme.form);
        return var1_1;
    }

    @Bean
    public DefaultClaimsToUserPolicy claimsToUserNamePolicy() {
        return new DefaultClaimsToUserPolicy(this.oidcConfig().userNameClaimName());
    }

    @Bean
    public DefaultClaimsToGrantedAuthoritiesPolicy claimsToGrantedAuthoritiesPolicy() {
        return new DefaultClaimsToGrantedAuthoritiesPolicy(this.oidcConfig().rolesClaimName());
    }

    @Bean
    public OpenIdLogoutSuccessHandler openIdLogoutSuccessHandler() {
        return new OpenIdLogoutSuccessHandler(this){
            private final /* synthetic */ OpenIdConnectConfig $outer;

            public void onLogoutSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException, ServletException {
                block1: {
                    if (authentication != null) {
                        String user = authentication.getName();
                        LogoutEvent event = new LogoutEvent(user);
                        EventBusHolder.publish((Object)event);
                    }
                    super.onLogoutSuccess(request, response, authentication);
                    if (authentication != null && authentication.getDetails() instanceof OpenIdConnectUserDetails) break block1;
                    response.sendRedirect(new StringBuilder(0).append(request.getContextPath()).append(this.$outer.loginUrlAuthenticationEntryPoint().getLoginFormUrl()).toString());
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super($outer.oidcConfig().logoutUri());
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    @Bean
    @Autowired
    public XlDeployLoginFormFilter defaultLoginFormFilter(AuthenticationManager authenticationManager, SessionAuthenticationStrategy sessionAuthenticationStrategy) {
        void var3_3;
        XlDeployLoginFormFilter filter = new XlDeployLoginFormFilter(this.defaultOidcMustacheTemplateSettings());
        filter.setAuthenticationManager(authenticationManager);
        filter.setSessionAuthenticationStrategy(sessionAuthenticationStrategy);
        return var3_3;
    }

    @Bean
    public LoginUrlAuthenticationEntryPoint loginUrlAuthenticationEntryPoint() {
        return new LoginUrlAuthenticationEntryPoint(this.oidcConfig().external_login());
    }

    /*
     * WARNING - void declaration
     */
    public OAuth2RestTemplate openIdTemplate(OAuth2ClientContext oauth2ClientContext) {
        void var2_2;
        block0: {
            OAuth2RestTemplate oAuth2RestTemplate = new OAuth2RestTemplate(this.openIdDetails(), oauth2ClientContext);
            if (!Strings.isNotEmpty((String)this.oidcConfig().proxyHost())) break block0;
            this.setProxy(oAuth2RestTemplate);
        }
        return var2_2;
    }

    private void setProxy(OAuth2RestTemplate oAuth2RestTemplate) {
        SimpleClientHttpRequestFactory requestFactory = new SimpleClientHttpRequestFactory();
        requestFactory.setProxy(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(this.oidcConfig().proxyHost(), Predef$.MODULE$.Integer2int(this.oidcConfig().proxyPort()))));
        AuthorizationCodeAccessTokenProvider authorizationCodeAccessTokenProvider = new AuthorizationCodeAccessTokenProvider();
        authorizationCodeAccessTokenProvider.setRequestFactory((ClientHttpRequestFactory)requestFactory);
        ImplicitAccessTokenProvider implicitAccessTokenProvider = new ImplicitAccessTokenProvider();
        implicitAccessTokenProvider.setRequestFactory((ClientHttpRequestFactory)requestFactory);
        AccessTokenProviderChain accessTokenProvider = new AccessTokenProviderChain(Arrays.asList((Object[])new AccessTokenProvider[]{authorizationCodeAccessTokenProvider, implicitAccessTokenProvider}));
        oAuth2RestTemplate.setAccessTokenProvider((AccessTokenProvider)accessTokenProvider);
    }

    /*
     * WARNING - void declaration
     */
    public Map<String, String> defaultOidcMustacheTemplateSettings() {
        void var1_1;
        HashMap<String, String> scope = new HashMap<String, String>();
        scope.put("productLogo", "./images/xl-deploy-logo.svg");
        scope.put("productColor", "#0099cc");
        scope.put("productIcon", "./favicon.ico");
        scope.put("productName", "XL Deploy");
        return var1_1;
    }
}

