/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xldeploy.authentication.oidc.conf;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import org.springframework.security.oauth2.jose.jws.SignatureAlgorithm;
import org.springframework.web.util.UriComponentsBuilder;
import scala.Predef$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005}b\u0001\u0002\u0016,\u0001aB\u0001b\u0010\u0001\u0003\u0002\u0003\u0006I\u0001\u0011\u0005\u0006\u000f\u0002!\t\u0001\u0013\u0005\b\u0019\u0002\u0011\r\u0011\"\u0001N\u0011\u0019I\u0006\u0001)A\u0005\u001d\"9!\f\u0001b\u0001\n\u0003i\u0005BB.\u0001A\u0003%a\nC\u0004]\u0001\t\u0007I\u0011A'\t\ru\u0003\u0001\u0015!\u0003O\u0011\u001dq\u0006A1A\u0005\u00025Caa\u0018\u0001!\u0002\u0013q\u0005b\u00021\u0001\u0005\u0004%\t!\u0014\u0005\u0007C\u0002\u0001\u000b\u0011\u0002(\t\u000f\t\u0004!\u0019!C\u0001\u001b\"11\r\u0001Q\u0001\n9Cq\u0001\u001a\u0001C\u0002\u0013\u0005Q\n\u0003\u0004f\u0001\u0001\u0006IA\u0014\u0005\bM\u0002\u0011\r\u0011\"\u0001N\u0011\u00199\u0007\u0001)A\u0005\u001d\"9\u0001\u000e\u0001b\u0001\n\u0003i\u0005BB5\u0001A\u0003%a\nC\u0004k\u0001\t\u0007I\u0011A'\t\r-\u0004\u0001\u0015!\u0003O\u0011\u001da\u0007A1A\u0005\u00025Ca!\u001c\u0001!\u0002\u0013q\u0005b\u00028\u0001\u0005\u0004%\t!\u0014\u0005\u0007_\u0002\u0001\u000b\u0011\u0002(\t\u000fA\u0004!\u0019!C\u0001\u001b\"1\u0011\u000f\u0001Q\u0001\n9CqA\u001d\u0001C\u0002\u0013\u0005Q\n\u0003\u0004t\u0001\u0001\u0006IA\u0014\u0005\bi\u0002\u0011\r\u0011\"\u0001N\u0011\u0019)\b\u0001)A\u0005\u001d\"9a\u000f\u0001b\u0001\n\u0003i\u0005BB<\u0001A\u0003%a\nC\u0004y\u0001\u0001\u0007I\u0011A=\t\u0013\u0005\u0015\u0001\u00011A\u0005\u0002\u0005\u001d\u0001bBA\n\u0001\u0001\u0006KA\u001f\u0005\b\u0003+\u0001A\u0011BA\f\u0011\u001d\t\u0019\u0003\u0001C\u0005\u0003KAq!!\f\u0001\t\u0013\ty\u0003C\u0004\u00026\u0001!I!a\u000e\u0003\u0015=KGmY\"p]\u001aLwM\u0003\u0002-[\u0005!1m\u001c8g\u0015\tqs&\u0001\u0003pS\u0012\u001c'B\u0001\u00192\u00039\tW\u000f\u001e5f]RL7-\u0019;j_:T!AM\u001a\u0002\u0011adG-\u001a9m_fT!\u0001N\u001b\u0002\u0013a,'-[1mC\n\u001c(\"\u0001\u001c\u0002\u0007\r|Wn\u0001\u0001\u0014\u0005\u0001I\u0004C\u0001\u001e>\u001b\u0005Y$\"\u0001\u001f\u0002\u000bM\u001c\u0017\r\\1\n\u0005yZ$AB!osJ+g-\u0001\u0004d_:4\u0017n\u001a\t\u0003\u0003\u0016k\u0011A\u0011\u0006\u0003\u007f\rS!\u0001R\u001b\u0002\u0011QL\b/Z:bM\u0016L!A\u0012\"\u0003\r\r{gNZ5h\u0003\u0019a\u0014N\\5u}Q\u0011\u0011j\u0013\t\u0003\u0015\u0002i\u0011a\u000b\u0005\u0006\u007f\t\u0001\r\u0001Q\u0001\u000fe\u0016<\u0017n\u001d;sCRLwN\\%e+\u0005q\u0005CA(W\u001d\t\u0001F\u000b\u0005\u0002Rw5\t!K\u0003\u0002To\u00051AH]8pizJ!!V\u001e\u0002\rA\u0013X\rZ3g\u0013\t9\u0006L\u0001\u0004TiJLgn\u001a\u0006\u0003+n\nqB]3hSN$(/\u0019;j_:LE\rI\u0001\tG2LWM\u001c;JI\u0006I1\r\\5f]RLE\rI\u0001\u0007SN\u001cX/\u001a:\u0002\u000f%\u001c8/^3sA\u0005a1\r\\5f]R\u001cVm\u0019:fi\u0006i1\r\\5f]R\u001cVm\u0019:fi\u0002\n\u0001B[<lg~+(/[\u0001\nU^\\7oX;sS\u0002\na\"Y2dKN\u001cHk\\6f]V\u0013\u0018.A\bbG\u000e,7o\u001d+pW\u0016tWK]5!\u0003Q)8/\u001a:BkRDwN]5{CRLwN\\+sS\u0006)Ro]3s\u0003V$\bn\u001c:ju\u0006$\u0018n\u001c8Ve&\u0004\u0013a\u0003:fI&\u0014Xm\u0019;Ve&\fAB]3eSJ,7\r^+sS\u0002\n\u0011\u0002\\8h_V$XK]5\u0002\u00151|wm\\;u+JL\u0007%A\u000bq_N$Hj\\4pkR\u0014V\rZ5sK\u000e$XK]5\u0002-A|7\u000f\u001e'pO>,HOU3eSJ,7\r^+sS\u0002\naB]8mKN\u001cE.Y5n\u001d\u0006lW-A\bs_2,7o\u00117bS6t\u0015-\\3!\u0003E)8/\u001a:OC6,7\t\\1j[:\u000bW.Z\u0001\u0013kN,'OT1nK\u000ec\u0017-[7OC6,\u0007%A\u0007jIR{7.\u001a8K/N\u000bEnZ\u0001\u000fS\u0012$vn[3o\u0015^\u001b\u0016\t\\4!\u00039)\u0007\u0010^3s]\u0006dw\f\\8hS:\fq\"\u001a=uKJt\u0017\r\\0m_\u001eLg\u000eI\u0001\u0017Y><\u0017N\\'fi\"|G\rR3tGJL\u0007\u000f^5p]\u00069Bn\\4j]6+G\u000f[8e\t\u0016\u001c8M]5qi&|g\u000eI\u0001\naJ|\u00070\u001f%pgR\f!\u0002\u001d:pqfDun\u001d;!\u0003%\u0001(o\u001c=z!>\u0014H/F\u0001{!\rY\u0018\u0011A\u0007\u0002y*\u0011QP`\u0001\u0005Y\u0006twMC\u0001\u0000\u0003\u0011Q\u0017M^1\n\u0007\u0005\rAPA\u0004J]R,w-\u001a:\u0002\u001bA\u0014x\u000e_=Q_J$x\fJ3r)\u0011\tI!a\u0004\u0011\u0007i\nY!C\u0002\u0002\u000em\u0012A!\u00168ji\"A\u0011\u0011\u0003\u0013\u0002\u0002\u0003\u0007!0A\u0002yIE\n!\u0002\u001d:pqf\u0004vN\u001d;!\u0003E9W\r^*ue&tw\r\u0015:pa\u0016\u0014H/\u001f\u000b\b\u001d\u0006e\u00111DA\u0010\u0011\u0015yd\u00051\u0001A\u0011\u0019\tiB\na\u0001\u001d\u0006!a.Y7f\u0011\u0019\t\tC\na\u0001\u001d\u0006aA-\u001a4bk2$h+\u00197vK\u0006qq-\u001a;J]R\u0004&o\u001c9feRLHc\u0002>\u0002(\u0005%\u00121\u0006\u0005\u0006\u007f\u001d\u0002\r\u0001\u0011\u0005\u0007\u0003;9\u0003\u0019\u0001(\t\r\u0005\u0005r\u00051\u0001{\u0003M9W\r^#oG>$W\rZ+sSN#(/\u001b8h)\rq\u0015\u0011\u0007\u0005\u0007\u0003gA\u0003\u0019\u0001(\u0002\u0007U\u0014\u0018.A\nhKR$UmY8eK\u0012,&/[*ue&tw\r\u0006\u0003\u0002:\u0005u\u0002cA>\u0002<%\u0011q\u000b \u0005\u0007\u0003gI\u0003\u0019\u0001(")
public class OidcConfig {
    private final String registrationId;
    private final String clientId;
    private final String issuer;
    private final String clientSecret;
    private final String jwks_uri;
    private final String accessTokenUri;
    private final String userAuthorizationUri;
    private final String redirectUri;
    private final String logoutUri;
    private final String postLogoutRedirectUri;
    private final String rolesClaimName;
    private final String userNameClaimName;
    private final String idTokenJWSAlg;
    private final String external_login;
    private final String loginMethodDescription;
    private final String proxyHost;
    private Integer proxyPort;

    public String registrationId() {
        return this.registrationId;
    }

    public String clientId() {
        return this.clientId;
    }

    public String issuer() {
        return this.issuer;
    }

    public String clientSecret() {
        return this.clientSecret;
    }

    public String jwks_uri() {
        return this.jwks_uri;
    }

    public String accessTokenUri() {
        return this.accessTokenUri;
    }

    public String userAuthorizationUri() {
        return this.userAuthorizationUri;
    }

    public String redirectUri() {
        return this.redirectUri;
    }

    public String logoutUri() {
        return this.logoutUri;
    }

    public String postLogoutRedirectUri() {
        return this.postLogoutRedirectUri;
    }

    public String rolesClaimName() {
        return this.rolesClaimName;
    }

    public String userNameClaimName() {
        return this.userNameClaimName;
    }

    public String idTokenJWSAlg() {
        return this.idTokenJWSAlg;
    }

    public String external_login() {
        return this.external_login;
    }

    public String loginMethodDescription() {
        return this.loginMethodDescription;
    }

    public String proxyHost() {
        return this.proxyHost;
    }

    public Integer proxyPort() {
        return this.proxyPort;
    }

    public void proxyPort_$eq(Integer x$1) {
        this.proxyPort = x$1;
    }

    private String getStringProperty(Config config, String name, String defaultValue) {
        String string;
        try {
            string = config.getString(name);
        }
        catch (ConfigException.Missing missing) {
            string = defaultValue;
        }
        return string;
    }

    private Integer getIntProperty(Config config, String name, Integer defaultValue) {
        Integer n;
        try {
            n = Predef$.MODULE$.int2Integer(config.getInt(name));
        }
        catch (ConfigException.Missing missing) {
            n = defaultValue;
        }
        return n;
    }

    private String getEncodedUriString(String uri) {
        String string;
        try {
            string = URI.create(uri).toASCIIString();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            string = UriComponentsBuilder.fromUriString((String)uri).build().toUri().toASCIIString();
        }
        return string;
    }

    private String getDecodedUriString(String uri) {
        String string;
        try {
            string = URLDecoder.decode(uri, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalArgumentException(String.format("Cannot decode value [%s] with 'utf-8' charset", uri));
        }
        return string;
    }

    public OidcConfig(Config config) {
        this.registrationId = "xl-deploy";
        this.clientId = config.getString("xl.security.auth.providers.oidc.clientId");
        this.issuer = config.getString("xl.security.auth.providers.oidc.issuer");
        this.clientSecret = config.getString("xl.security.auth.providers.oidc.clientSecret");
        this.jwks_uri = this.getEncodedUriString(config.getString("xl.security.auth.providers.oidc.keyRetrievalUri"));
        this.accessTokenUri = this.getDecodedUriString(config.getString("xl.security.auth.providers.oidc.accessTokenUri"));
        this.userAuthorizationUri = this.getEncodedUriString(config.getString("xl.security.auth.providers.oidc.userAuthorizationUri"));
        this.redirectUri = this.getEncodedUriString(config.getString("xl.security.auth.providers.oidc.redirectUri"));
        this.logoutUri = this.getDecodedUriString(config.getString("xl.security.auth.providers.oidc.logoutUri"));
        this.postLogoutRedirectUri = this.getStringProperty(config, "xl.security.auth.providers.oidc.postLogoutRedirectUri", this.redirectUri());
        this.rolesClaimName = config.getString("xl.security.auth.providers.oidc.rolesClaimName");
        this.userNameClaimName = config.getString("xl.security.auth.providers.oidc.userNameClaimName");
        this.idTokenJWSAlg = this.getStringProperty(config, "xl.security.auth.providers.oidc.idTokenJWSAlg", SignatureAlgorithm.RS256.getName());
        this.external_login = new StringBuilder(22).append("/oauth2/authorization").append("/").append(this.registrationId()).toString();
        this.loginMethodDescription = this.getStringProperty(config, "xl.security.auth.providers.oidc.loginMethodDescription", "External login (OpenID Connect)");
        this.proxyHost = this.getStringProperty(config, "xl.security.auth.providers.oidc.proxyHost", null);
        this.proxyPort = this.getIntProperty(config, "xl.security.auth.providers.oidc.proxyPort", null);
    }
}

