import uuid


class ElbUtils:
    def __init__(self, deployed):
        self.deployed = deployed

    def is_set_modified(self, prev, cur):
        return len(prev - cur) != 0 or len(cur - prev) != 0

    def get_collection_pretty_printed(self, elements):
        return ", ".join(map(lambda value: str(value), sorted(elements)))

    def is_ci_property_modified(self, prev, cur):
        return cur != prev

    def get_delta(self, set1, set2):
        return set1 - set2

    def get_common_elements(self, set1, set2):
        return set1.intersection(set2)

    def has_no_common_elements(self, set1, set2):
        return not bool(self.get_common_elements(set1, set2))

    def get_listener_pretty_printed(self, listener):
        return "%s:%s->%s:%s" % (
            listener.protocol,
            listener.loadBalancerPort,
            listener.instanceProtocol,
            listener.instancePort
        )

    def get_listeners_pretty_printed(self, listeners):
        return self.get_collection_pretty_printed(
            set(map(lambda listener: self.get_listener_pretty_printed(listener=listener), listeners))
        )

    def get_delta_pretty_printed(self, set1, set2):
        return self.get_collection_pretty_printed(self.get_delta(set1=set1, set2=set2))

    def get_listener_as_dictionary(self, listener):
        return self.filter_empty_params({
            'InstancePort': int(listener.instancePort),
            'InstanceProtocol': listener.instanceProtocol,
            'LoadBalancerPort': int(listener.loadBalancerPort),
            'Protocol': listener.protocol,
            'SSLCertificateId': listener.sslCertificateId
        })

    def filter_empty_params(self, params):
        for k, v in dict(params).items():
            if v is None:
                del params[k]
        return params

    def get_dummy_listener(self):
        return {
            'InstancePort': self.deployed.dummyListenerLoadBalancerPort,
            'InstanceProtocol': 'HTTP',
            'LoadBalancerPort': self.deployed.dummyListenerLoadBalancerPort,
            'Protocol': 'HTTP'
        }

    def get_dummy_listener_pretty_printed(self):
        listener = self.get_dummy_listener()
        return "%s:%s->%s:%s" % (
            listener['Protocol'],
            listener['LoadBalancerPort'],
            listener['InstanceProtocol'],
            listener['InstancePort'],
        )

    def generate_policy_name(self):
        return str(uuid.uuid1())

    def get_values_from_dictionaries(self, dict, property_name):
        return map(lambda dct: dct[property_name], dict) if bool(dict and dict[0] and dict[0][property_name]) else []
