from ecs import TaskServiceHelper

task_service_helper = TaskServiceHelper(previousDeployed)

status = task_service_helper.get_service_status()

if status != 'INACTIVE':
    fail_message = "Service is still DRAINING or ACTIVE."
    wait_message = "Waiting for service {0} to drain completely.".format(previousDeployed.serviceName)
    result = task_service_helper.retry_or_fail(context, previousDeployed.serviceName,
                                               previousDeployed.maxDrainRetryCount, fail_message, wait_message)
else:
    previousDeployed.serviceArn = None
    if deployed:
        deployed.serviceArn = None
    print "Service removed."
