class RDSSubnetGroupUtils:
    def __init__(self, deployed, previous_deployed=None):
        self.__deployed = deployed
        self.__previous_deployed = previous_deployed

    def is_any_attribute_modified(self):
        return self.is_description_modified() or \
               self.are_subnets_modified()

    def is_subnet_group_modified(self):
        return self.is_description_modified() or \
               self.are_subnets_modified() or \
               self.are_tags_modified()

    def get_remaining_subnets(self):
        return self.__deployed.subnets.intersection(self.__previous_deployed.subnets)

    def get_deleted_subnets(self):
        return self.__previous_deployed.subnets - self.__deployed.subnets

    def are_subnets_added(self):
        return bool(self.__deployed.subnets - self.__previous_deployed.subnets)

    def is_description_modified(self):
        return self.__deployed.description != self.__previous_deployed.description

    def are_subnets_modified(self):
        return self.__deployed.subnets != self.__previous_deployed.subnets

    def are_tags_modified(self):
        return bool(self.get_tags_to_be_added() or self.get_tags_to_be_deleted())

    def get_tags_to_be_deleted(self):
        return dict(
            (key, value) for key, value in self.__previous_deployed.subnetGroupsTags.iteritems() if
            key not in self.__deployed.subnetGroupsTags)

    def get_tags_to_be_added(self):
        return dict(
            (key, value) for key, value in self.__deployed.subnetGroupsTags.iteritems() if
            key not in self.__previous_deployed.subnetGroupsTags or self.__previous_deployed.subnetGroupsTags[
                key] != value)

    def get_collection_pretty_printed(self, elements):
        return ", ".join(map(lambda value: str(value), sorted(elements)))
