import yaml

def generic_constructor(loader, tag, node):
    classname = node.__class__.__name__
    if classname == 'SequenceNode':
        return loader.construct_sequence(node)
    elif classname == 'MappingNode':
        return loader.construct_mapping(node)
    else:
        return loader.construct_scalar(node)


def set_generic_constructor():
    yaml.add_multi_constructor('', generic_constructor)
