from ec2.ec2_helper import EC2Helper


class IGHelper(EC2Helper):
    def __init__(self, deployed):
        super(IGHelper, self).__init__(deployed)

    def create_internet_gateway(self):
        create_ig_response = self.ec2_client.create_internet_gateway()
        if create_ig_response['ResponseMetadata']['HTTPStatusCode'] == 200:
            self.deployed.internetGatewayId = create_ig_response['InternetGateway']['InternetGatewayId']
        return create_ig_response

    def delete_internet_gateway(self):
        delete_ig_response = self.ec2_client.delete_internet_gateway(
            InternetGatewayId=self.deployed.internetGatewayId
        )
        return delete_ig_response

    def attach_internet_gateway(self):
        attach_ig_response = self.ec2_client.attach_internet_gateway(
            InternetGatewayId=self.deployed.internetGatewayId,
            VpcId=self.deployed.vpcId
        )
        return attach_ig_response

    def detach_internet_gateway(self):
        detach_ig_response = self.ec2_client.detach_internet_gateway(
            InternetGatewayId=self.deployed.internetGatewayId,
            VpcId=self.deployed.vpcId
        )
        return detach_ig_response

    def is_internet_gateway_available(self, internet_gateway_id):
        try:
            internet_gateways = self.ec2_client.describe_internet_gateways(InternetGatewayIds=[internet_gateway_id])["InternetGateways"]
            return len(internet_gateways) > 0
        except:
            return False

    def is_vpc_attached(self, internet_gateway_id):
        try:
            internet_gateways = self.ec2_client.describe_internet_gateways(InternetGatewayIds=[internet_gateway_id])["InternetGateways"]
            return internet_gateways[0]["Attachments"][0]["VpcId"] == self.deployed.vpcId
        except:
            return False
