from ec2.ig.ig_helper import IGHelper

# Adding internet gateway steps
ig_helper = IGHelper(previousDeployed)

previous_vpc_name = previousDeployed.vpcName if previousDeployed.vpcName else previousDeployed.name
previous_gateway_name = previousDeployed.internetGatewayName if previousDeployed.internetGatewayName else previous_vpc_name + '-gateway'

if previousDeployed.createInternetGateway:
    if ig_helper.is_vpc_attached(previousDeployed.internetGatewayId):
        description = "Detach internet gateway %s from VPC %s in %s" % (previous_gateway_name, previous_vpc_name, previousDeployed.container.name)

        context.addStepWithCheckpoint(steps.jython(
            description=description,
            script="ec2/ig/detach_internet_gateway.py",
            order=39
        ), delta)

    description = "Destroy internet gateway %s from %s" % (previous_gateway_name, previousDeployed.container.name)

    context.addStepWithCheckpoint(steps.jython(
        description=description,
        script="ec2/ig/delete_internet_gateway.py",
        order=40
    ), delta)

# Adding peering connection deletion steps
if hasattr(previousDeployed, "peerVPCs") and previousDeployed.peerVPCs:
    context.addStepWithCheckpoint(steps.jython(
        description="Destroy peer connection for VPC %s in %s" % (previous_vpc_name, previousDeployed.container.name),
        script="ec2/vpc/destroy_peer_connection.py",
        order=40,
        jython_context = {"peer_vpcs": previousDeployed.peerVPCs}
    ), delta)


# Adding vpc steps
context.addStepWithCheckpoint(steps.jython(
    description="Destroy VPC %s from %s" % (previous_vpc_name, previousDeployed.container.name),
    script="ec2/vpc/destroy.py",
    order=49
), delta)
