from alb.tg.tg_helper import TargetGroupHelper

tg_helper = TargetGroupHelper(deployed)
target_name = deployed.targetName if deployed.targetName else deployed.name

# Validate target group
tg_helper.validate_target_group()
# Create target group
context.addStepWithCheckpoint(steps.jython(
    description="Create target group {} on {}".format(target_name, deployed.container.name),
    script="alb/tg/steps/create_target_group.py",
    order=86
), delta)

# Configure target group
context.addStepWithCheckpoint(steps.jython(
    description="Configure target group {} on {}".format(target_name, deployed.container.name),
    script="alb/tg/steps/configure_target_group.py",
    order=87
), delta)

# Associate instances
if deployed.instances:
    context.addStepWithCheckpoint(steps.jython(
        description="Associate instances to target group {} on {}".format(target_name, deployed.container.name),
        script="alb/tg/steps/associate_instances.py",
        order=87
    ), delta)
