from ec2.ec2_helper import EC2Helper

ec2_helper = EC2Helper(deployed)

if deployed.region != previousDeployed.region:
    raise RuntimeError("Region cannot be modified for a route table")

if deployed.vpc != previousDeployed.vpc:
    raise RuntimeError("VPC cannot be modified for a route table")

route_table_name = deployed.routeTableName if deployed.routeTableName else deployed.name
previous_deployed_route_table_name = previousDeployed.routeTableName if previousDeployed.routeTableName else previousDeployed.name

is_previous_table_main = previousDeployed.is_main

if is_previous_table_main != deployed.is_main:
    if not deployed.is_main:
        context.addStep(steps.jython(
            description="Unset route table %s as main table (and fallback to original) on VPC %s on %s" % (previous_deployed_route_table_name, deployed.vpc, deployed.container.name),
            script="ec2/vpc/routes/set_fallback_as_main_table.py",
            order=63
        ))
    else:
        context.addStep(steps.jython(
            description="Set route table %s as main table on VPC %s on %s" % (previous_deployed_route_table_name, deployed.vpc, deployed.container.name),
            script="ec2/vpc/routes/set_as_main_table.py",
            order=65
        ))

if route_table_name != previous_deployed_route_table_name or \
        set(previousDeployed.subnets) != set(deployed.subnets):
    context.addStepWithCheckpoint(steps.jython(
        description="Modify name and/or associate/disassociate subnets of route table %s on VPC %s on %s" % (previous_deployed_route_table_name, deployed.vpc, deployed.container.name),
        script="ec2/vpc/routes/modify_route_table.py",
        order=64
    ), delta)

context.addStepWithCheckpoint(steps.jython(
    description="Update routes of route table %s on VPC %s on %s" % (previous_deployed_route_table_name, deployed.vpc, deployed.container.name),
    script="ec2/vpc/routes/add_remove_routes.py",
    order=66
), delta)


