from ec2.vpc.subnet.sn_helper import SNHelper

sn_helper = SNHelper(deployed)

if deployed.mapPublicIpOnLaunch != previousDeployed.mapPublicIpOnLaunch:
    sn_helper.modify_auto_assign_public_ip()
    print "Auto assign public IP modified to %s for subnet with ID %s." % (deployed.mapPublicIpOnLaunch, deployed.subnetId)

if deployed.assignIpv6AddressOnCreation != previousDeployed.assignIpv6AddressOnCreation:
    sn_helper.modify_auto_assign_ipv6_address()
    print "Auto assign IPv6 address modified to %s for subnet with ID %s." % (deployed.assignIpv6AddressOnCreation, deployed.subnetId)

subnet_name = deployed.subnetName if deployed.subnetName else deployed.name
previous_deployed_subnet_name = previousDeployed.subnetName if previousDeployed.subnetName else previousDeployed.name

if subnet_name != previous_deployed_subnet_name:
    sn_helper.set_resource_name(deployed.subnetId, subnet_name)
