class RunnableHelper(object):
    def __init__(self, deployed):
        self.deployed = deployed

    def validate_runnable(self):
        if self.deployed.launchType == 'FARGATE':
            if not bool(self.deployed.networkMode) or self.deployed.networkMode != 'awsvpc':
                raise RuntimeError("Fargate task definitions require that the network mode is set to awsvpc.")
            elif not bool(self.deployed.cpu) or not bool(self.deployed.memory):
                raise RuntimeError("Fargate task definitions require that CPU and memory are specified at the task level.")
            elif not bool(self.deployed.subnets):
                raise RuntimeError("Fargate task definitions require that in VPC configurations, one or more subnets "
                                   "are specified to attach the network interface.")
        self.validate_port_mappings()

    def validate_port_mappings(self):
        if self.deployed.networkMode == 'awsvpc' or self.deployed.networkMode == 'host':
            for container in self.deployed.containerDefinitions:
                for port_mapping in container.portMappings:
                    if bool(port_mapping.hostPort):
                        raise RuntimeError("For network mode 'awsvpc' or 'host', host port must be empty for container: "
                                           "{0} and port mapping: {1}.".format(container.name, port_mapping.name))
