from commons.aws_helper import AWSHelper


class RDSHelper(AWSHelper):
    def __init__(self, deployed):
        super(RDSHelper, self).__init__(deployed)
        self.rds_client = self.get_aws_client(resource_name="rds", region=deployed.region)

    def set_rds_resource_tags(self, resource_tags, resource_id):
        tags = RDSHelper.get_tags(resource_tags)
        if len(tags) > 0:
            self.rds_client.add_tags_to_resource(ResourceName=resource_id, Tags=tags)

    def delete_rds_resource_tags(self, resource_tags, resource_id):
        self.rds_client.remove_tags_from_resource(ResourceName=resource_id, TagKeys=resource_tags.keys())

    @staticmethod
    def get_tags(resource_tags):
        return map(lambda tag_key: {'Key': tag_key, 'Value': resource_tags[tag_key]}, resource_tags.keys()) if bool(resource_tags) else []
