from ec2.elastic_ip.elastic_ip_helper import EC2ElasticIpHelper

elastic_ip_helper = EC2ElasticIpHelper(deployed)

if previousDeployed and previousDeployed.attachElasticIp:
    elasticIp = previousDeployed.publicIp
    allocation_id = previousDeployed.elasticIpAllocationId
else:
    elasticIp = deployed.publicIp
    allocation_id = deployed.elasticIpAllocationId

print "Associating %s with instance %s" % (elasticIp, deployed.instanceId)
if deployed.elasticIpDomain == 'vpc':
    elastic_ip_helper.associate_elastic_ip(elasticIp, allocation_id)
else:
    elastic_ip_helper.associate_elastic_ip(elasticIp)
print "Association completed"

# required for update scenario when attachElasticIp becomes true from false
deployed.publicIp = elastic_ip_helper.get_public_ip()
deployed.publicHostname = elastic_ip_helper.get_public_hostname()
