from ec2.sg.sg_helper import SGHelper

sg_helper = SGHelper(deployed)

if previousDeployed:
    prev_sg_helper = SGHelper(previousDeployed)
    if prev_sg_helper.is_outbound_rules_exist():
        print "Deleting outbound rules from security group %s on %s" % (previousDeployed.securityGroupName if previousDeployed.securityGroupName else previousDeployed.name, previousDeployed.container.name)
        prev_sg_helper.remove_outbound_rules()

if sg_helper.is_outbound_rules_exist():
    # Remove default outbound rules for vpc based security group
    if sg_helper.is_vpc_provided():
        ipv4_found = sg_helper.is_ipv4_default_outbound_rules_exist()
        ipv6_found = sg_helper.is_ipv6_default_outbound_rules_exist()
        if ipv4_found or ipv6_found:
            print "Deleting default outbound rules from security group %s on %s" % (deployed.securityGroupName if deployed.securityGroupName else deployed.name, deployed.container.name)

        if ipv4_found :
            sg_helper.remove_ipv4_default_outbound_rules()

        if ipv6_found:
            sg_helper.remove_ipv6_default_outbound_rules()

    print "Adding outbound rules to security group %s on %s" % (deployed.securityGroupName if deployed.securityGroupName else deployed.name, deployed.container.name)
    sg_helper.add_outbound_rules()
