from cloudformation.utils.cf_client import CFClient
from com.xebialabs.deployit.provision import ProvisionHelper


class CreateResources(object):
    def __init__(self, task_context):
        self.repository = task_context['repositoryService']
        self.context = task_context['context']
        self.previousDeployed = task_context['previousDeployed']
        self.deployed = task_context['deployed']
        self.deployedApplication = task_context['deployedApplication']
        self.client = CFClient.new_instance(deployed.container)
        self.environment_id = ProvisionHelper.getProvisionEnvironmentId(
            self.deployed.environmentPath, self.deployedApplication.environment.id)
        self.generated_ids = []
        self.generated_cis = []
        self.cis_to_delete = []

    def process(self):
        self.process_resources(self.client.list_resources(self.deployed))
        self.process_cis_to_delete()
        self.update_environment_members()
        self.update_generated_cis()
        self.delete_removed_resources()

    def process_resources(self, resources):
        for resource in resources:
            cis = self.client.create_cis(
                resource, self.deployed.container.account)
            if cis is not None:
                for ci in cis:
                    if ci is not None:
                        if self.repository.exists(ci.id):
                            self.repository.update(ci.id, ci)
                            print("'%s' of type '%s' updated from '%s' resource." % (
                                ci.id, ci.type, resource['ResourceType']))
                        else:
                            self.repository.create(ci.id, ci)
                            print("'%s' of type '%s' created from '%s' resource." % (
                                ci.id, ci.type, resource['ResourceType']))
                        self.generated_cis.append(ci)
                        self.generated_ids.append(ci.id)

    def process_cis_to_delete(self):
        if (self.previousDeployed):
            for ci in self.previousDeployed.generatedConfigurationItems:
                if ci.type != "udm.Environment" and ci.type != "udm.Dictionary":
                    if ci.id not in self.generated_ids:
                        self.cis_to_delete.append(ci.id)

    def update_environment_members(self):
        environment = ProvisionHelper.getOrCreateEnvironment(
            self.environment_id, self.context)
        members = environment.members
        for ci in self.generated_cis:
            if 'Environments/' not in ci.id:
                if 'kube-system' in ci.name:
                    self.create_kube_system_environment(ci)
                else:
                    members.add(ci)
        members_to_remove = []
        for ci in members:
            if ci.id in self.cis_to_delete:
                print("'%s' removed from 'members' property of environment '%s'" %
                      (ci.id, self.environment_id))
                members_to_remove.append(ci)
        for ci in members_to_remove:
            members.remove(ci)
        environment.setMembers(members)
        self.repository.update(self.environment_id, environment)

    def create_kube_system_environment(self, kube_system):
        cluster_id = kube_system.id[:kube_system.id.rfind('/')]
        cluster_name = cluster_id[cluster_id.rfind('/')+1:]
        kube_system_environment_id = self.environment_id[:self.environment_id.rfind('/')+1] + cluster_name + "-kube-system"
        environment = ProvisionHelper.getOrCreateEnvironment(
            kube_system_environment_id, self.context)
        members = environment.members
        members.add(kube_system)
        environment.setMembers(members)
        self.generated_cis.append(environment)
        print "'%s' environment created with member '%s'" % (kube_system_environment_id, kube_system.id) 
        self.repository.update(kube_system_environment_id, environment)

    def update_generated_cis(self):
        generatedConfigurationItems = self.deployed.generatedConfigurationItems
        for ci in self.generated_cis:
            generatedConfigurationItems.add(ci)
        if self.environment_id != self.deployedApplication.environment.id:
            generatedConfigurationItems.add(self.repository.read(self.environment_id))

        generated_to_remove = []
        for ci in generatedConfigurationItems:
            if ci.id in self.cis_to_delete:
                print("'%s' removed from 'generatedConfigurationItems' property of '%s'" % (
                    ci.id, self.deployed.id))
                generated_to_remove.append(ci)
        for ci in generated_to_remove:
            generatedConfigurationItems.remove(ci)
        self.deployed.setGeneratedConfigurationItems(generatedConfigurationItems)
        if self.repository.exists(self.deployed.id):
            self.repository.update(self.deployed.id, self.deployed)

    def delete_removed_resources(self):
        for ci_id in self.cis_to_delete:
            self.repository.delete(ci_id)
            print("'%s' deleted" % ci_id)


CreateResources(locals()).process()
