#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

import yaml
from xld.xlyaml.generic_tag import GenericScalar
from xld.xlyaml.generic_tag import GenericSequence
from xld.xlyaml.generic_tag import GenericMapping


class text(unicode):
    pass


def text_representer(dumper, data):
    return dumper.represent_scalar('tag:yaml.org,2002:str', data, style='|')


def scalar_representer(dumper, data):
    return dumper.represent_scalar(data.tag, data.value, style='|')


def mapping_representer(dumper, data):
    return dumper.represent_mapping('tag:yaml.org,2002:map', data.value, flow_style=False)


def sequence_representer(dumper, data):
    return dumper.represent_sequence('tag:yaml.org,2002:seq', data.value, flow_style=False)


def yaml_safe_dump(_dict):

    yaml.add_representer(GenericScalar, GenericScalar.to_yaml,
                         Dumper=yaml.SafeDumper)
    yaml.add_representer(GenericSequence, GenericSequence.to_yaml,
                         Dumper=yaml.SafeDumper)
    yaml.add_representer(GenericMapping, GenericMapping.to_yaml,
                         Dumper=yaml.SafeDumper)
    yaml.add_representer(text, text_representer,
                         Dumper=yaml.SafeDumper)
    yaml.add_representer(yaml.ScalarNode, scalar_representer,
                         Dumper=yaml.SafeDumper)
    yaml.add_representer(yaml.MappingNode, mapping_representer,
                         Dumper=yaml.SafeDumper)
    yaml.add_representer(yaml.SequenceNode, sequence_representer,
                         Dumper=yaml.SafeDumper)

    if 'data' in _dict:
        for i in _dict['data']:
            data = _dict['data'][i]
            data = data if isinstance(
                data, str) else data.encode('ascii', 'replace')
            _dict['data'][i] = text(data)
    return yaml.safe_dump(_dict, default_flow_style=False)
